/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DivineGuardSpell
implements ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("b06837fa-7071-4485-ab15-8d5b7811dc30");
    private final Cooldown cooldown = new Cooldown();

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(10.0f);
    }

    @Override
    public Optional<GahDamage> onEntityAttack(ServerPlayer player, Entity attacker, GahDamage totalDamageDealt) {
        if (!player.m_21254_()) {
            return ICooldownGahSpell.super.onEntityAttack(player, attacker, totalDamageDealt);
        }
        if (!this.getCooldown().checkAndReset((LivingEntity)player)) {
            return ICooldownGahSpell.super.onEntityAttack(player, attacker, totalDamageDealt);
        }
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.KNIGHT_SUPER_BLOCK.get());
        this.syncToClient(player, ID);
        return Optional.empty();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.divine_guard.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.divine_guard.description")});
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("divine_guard").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("divine_guard").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.EMPTY;
    }
}

