/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.entities.projectile.GahArrow;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientMagicExplosion;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;

public class ExplodingArrowsSpell
implements ILevelingGahSpell {
    public static final UUID ID = UUID.fromString("5d5430de-0bce-4db7-b8e1-5513ce36b67b");
    private int spellPoints = 0;
    private int procs = 0;

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("exploding_arrows").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("exploding_arrows").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.spell(player, 0.0f, 0.0f, 2.0f + 0.5f * (float)this.getSpellPoints(), 1.0f + 0.1f * (float)this.getSpellPoints());
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.exploding_arrows_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.exploding_arrows_spell.description")});
    }

    @Override
    public GahDamage onIndirectAttackEntity(ServerPlayer player, Entity attackingEntity, Entity target) {
        GahArrow arrow;
        if (!(attackingEntity instanceof GahArrow) || !(arrow = (GahArrow)attackingEntity).isAutoAttack()) {
            return GahDamage.ZERO;
        }
        if (this.procs < 2) {
            ++this.procs;
            return GahDamage.ZERO;
        }
        this.procs = 0;
        NetworkChannel.sendToClientsInLevel((ServerLevel)player.m_9236_(), ClientMagicExplosion.Message.from((Entity)arrow));
        this.syncToClient(player, ID);
        GahStats stats = this.getStats((Player)player);
        return new GahCombat(stats).calculateMagicDamage(target);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = ILevelingGahSpell.super.serializeNBT();
        nbt.m_128405_("procs", this.procs);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt);
        this.procs = nbt.m_128451_("procs");
    }

    @Override
    public void onItemUse(Player player, ItemStack stack) {
        if (!(stack.m_41720_() instanceof BowItem) || this.procs < 2) {
            return;
        }
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.RANGER_EXPLOSIVE_ARROW_SHOOT.get());
    }
}

