/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.Fireball;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FireballSpell
implements ILevelingGahSpell,
IProjectileGahSpell<Fireball>,
ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("41e7a3cc-49af-4ef9-b73b-f7ad9530324b");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(2.5f) - TimeUtils.secondsToTicks(0.075f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 1.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 1.0f + 0.1f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        Level level = player.m_9236_();
        Fireball fireball = new Fireball((LivingEntity)player);
        fireball.shootFromEntity((LivingEntity)player, 2.5f, 1.0f);
        return level.m_7967_((Entity)fireball);
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        ArrayList launchSounds = Lists.newArrayList((Object[])new SoundEvent[]{(SoundEvent)Sounds.MAGE_FIREBALL_SHOOT.get(), SoundEvents.f_11936_});
        EntityUtils.playSounds((LivingEntity)player, launchSounds);
        EntityUtils.swing(player);
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("fireball").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("fireball").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.fireball_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.fireball_spell.description")});
    }

    @Override
    @NotNull
    public EntityType<Fireball> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.FIREBALL.get();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }
}

