/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.FrostBeam;
import com.dee12452.gahoodrpg.common.entities.projectile.FrostBlast;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSetProgressBar;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientStopSound;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrostBeamSpell
implements ILevelingGahSpell,
IProjectileGahSpell<FrostBlast>,
ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("4452aad8-4611-4558-9e5e-056f433163cf");
    private final Cooldown cooldown = new Cooldown();
    private final Set<UUID> frostBlasts = new HashSet<UUID>();
    private int spellPoints = 0;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("frost_beam").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("frost_beam").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.frost_beam_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.frost_beam_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(20.0f) - TimeUtils.secondsToTicks(0.5f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 1 + this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.1f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        NetworkChannel.sendToClient(player, new ClientSetProgressBar.Message(GahoodRPGClient.ProgressBarType.FROST_BLAST));
        FrostBeam beam = new FrostBeam((LivingEntity)player);
        player.m_9236_().m_7967_((Entity)beam);
        this.frostBlasts.add(beam.m_20148_());
        return true;
    }

    @Override
    public void onPlayerDeath(Player player, @Nullable Entity killer) {
        this.onReleaseSpell(player);
    }

    @Override
    public void onReleaseSpell(Player player) {
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        if (this.frostBlasts.isEmpty()) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)serverPlayer.m_9236_();
        this.frostBlasts.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(Objects::nonNull).forEach(fb -> ((FrostBeam)((Object)fb)).markForRemoval());
        this.frostBlasts.clear();
        NetworkChannel.sendToClient(serverPlayer, new ClientSetProgressBar.Message(GahoodRPGClient.ProgressBarType.NONE));
        NetworkChannel.sendToClient(serverPlayer, new ClientStopSound.Message((SoundEvent)Sounds.MAGE_FROST_BEAM_CHARGE.get(), SoundSource.PLAYERS));
    }

    @Override
    @NotNull
    public EntityType<FrostBlast> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.FROST_BLAST.get();
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.MAGE_FROST_BEAM_SHOOT.get());
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.MAGE_FROST_BEAM_CHARGE.get(), 0.25f);
        EntityUtils.swing(player);
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128405_("size", this.frostBlasts.size());
        int idx = 0;
        for (UUID id : this.frostBlasts) {
            nbt.m_128362_(String.format("id%d", idx), id);
            ++idx;
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        this.frostBlasts.clear();
        int size = nbt.m_128451_("size");
        for (int idx = 0; idx < size; ++idx) {
            this.frostBlasts.add(nbt.m_128342_(String.format("id%d", idx)));
        }
    }
}

