/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.BladeCrashSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.BladeDanceSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.CallOfTheWildSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.CrashGuardSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.DivineGuardSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ExplodingArrowsSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.FireballSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.FrostBeamSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.LightningBoltSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.MeteorSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.PortalJumpSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.PowerSlashSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.RainingArrowsSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.RootingVineSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ShieldThrowSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.SpellRegistrationException;
import com.dee12452.gahoodrpg.common.capabilities.spell.SwordBarrageSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ThornShieldSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.TwisterSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.UnlimitedArrowsSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ValiantChargeSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.WarCrySpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.WindslashSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.WolfPackSpell;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

public class GahSpells {
    private static final Map<UUID, Supplier<IGahSpell>> REGISTER = new HashMap<UUID, Supplier<IGahSpell>>();

    private GahSpells() {
    }

    public static void register(UUID id, Supplier<IGahSpell> spellSupplier) {
        if (REGISTER.containsKey(id)) {
            throw new SpellRegistrationException(String.format("Duplicate spell registered with UUID %s", id.toString()));
        }
        REGISTER.put(id, spellSupplier);
    }

    public static void deregister(UUID id) {
        REGISTER.remove(id);
    }

    public static List<Pair<UUID, Supplier<IGahSpell>>> getSpells() {
        return REGISTER.entrySet().stream().map(Pair::of).toList();
    }

    public static IGahSpell createSpell(UUID spellId) throws SpellRegistrationException {
        if (!REGISTER.containsKey(spellId)) {
            throw new SpellRegistrationException(String.format("No spell registered with UUID %s", spellId.toString()));
        }
        return REGISTER.get(spellId).get();
    }

    static {
        GahSpells.register(CallOfTheWildSpell.ID, CallOfTheWildSpell::new);
        GahSpells.register(ExplodingArrowsSpell.ID, ExplodingArrowsSpell::new);
        GahSpells.register(RainingArrowsSpell.ID, RainingArrowsSpell::new);
        GahSpells.register(RootingVineSpell.ID, RootingVineSpell::new);
        GahSpells.register(UnlimitedArrowsSpell.ID, UnlimitedArrowsSpell::new);
        GahSpells.register(WolfPackSpell.ID, WolfPackSpell::new);
        GahSpells.register(FireballSpell.ID, FireballSpell::new);
        GahSpells.register(FrostBeamSpell.ID, FrostBeamSpell::new);
        GahSpells.register(LightningBoltSpell.ID, LightningBoltSpell::new);
        GahSpells.register(MeteorSpell.ID, MeteorSpell::new);
        GahSpells.register(PortalJumpSpell.ID, PortalJumpSpell::new);
        GahSpells.register(WindslashSpell.ID, WindslashSpell::new);
        GahSpells.register(TwisterSpell.ID, TwisterSpell::new);
        GahSpells.register(SwordBarrageSpell.ID, SwordBarrageSpell::new);
        GahSpells.register(PowerSlashSpell.ID, PowerSlashSpell::new);
        GahSpells.register(WarCrySpell.ID, WarCrySpell::new);
        GahSpells.register(BladeDanceSpell.ID, BladeDanceSpell::new);
        GahSpells.register(BladeCrashSpell.ID, BladeCrashSpell::new);
        GahSpells.register(DivineGuardSpell.ID, DivineGuardSpell::new);
        GahSpells.register(CrashGuardSpell.ID, CrashGuardSpell::new);
        GahSpells.register(ShieldThrowSpell.ID, ShieldThrowSpell::new);
        GahSpells.register(ThornShieldSpell.ID, ThornShieldSpell::new);
        GahSpells.register(ValiantChargeSpell.ID, ValiantChargeSpell::new);
    }
}

