/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSpellSync;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerSpellSync;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public interface IGahSpell
extends INBTSerializable<CompoundTag> {
    public Component getName();

    public List<Component> getDescriptions();

    default public List<Component> loadDescriptions(String prefix, int numberOfDescriptions) {
        ArrayList descriptions = Lists.newArrayList();
        for (int i = 1; i <= numberOfDescriptions; ++i) {
            descriptions.add(Component.m_237115_((String)String.format("%s.%d", prefix, i)));
        }
        return descriptions;
    }

    public ResourceLocation getIcon();

    public ResourceLocation getOverlay();

    default public boolean canUse() {
        return true;
    }

    public GahStats getStats(Player var1);

    default public void onEnable(Player player) {
    }

    default public void onDisable(Player player) {
    }

    default public void onActivateSpell(Player player) {
    }

    default public void onReleaseSpell(Player player) {
    }

    default public void onJump(Player player) {
    }

    default public GahDamage onAttackEntity(ServerPlayer player, Entity target) {
        return GahDamage.ZERO;
    }

    default public Optional<GahDamage> onEntityAttack(ServerPlayer player, Entity attacker, GahDamage totalDamageDealt) {
        return Optional.of(GahDamage.ZERO);
    }

    default public GahDamage onIndirectAttackEntity(ServerPlayer player, Entity attackingEntity, Entity target) {
        return GahDamage.ZERO;
    }

    default public float onShieldBlock(ServerPlayer player, Entity attacker) {
        return 0.0f;
    }

    default public void onTick(Player player) {
    }

    default public void onDimensionChange(ServerPlayer player) {
    }

    default public void onKillEntity(ServerPlayer player, LivingEntity deadEntity) {
    }

    default public void onPlayerDeath(Player player, @Nullable Entity killer) {
    }

    default public void onPlayerRespawn(ServerPlayer player) {
    }

    default public boolean onPlayerFall(Player player, float distance) {
        return false;
    }

    default public void onItemUse(Player player, ItemStack stack) {
    }

    default public ItemStack findAmmo(ServerPlayer player, ItemStack weapon, ItemStack identifiedAmmo) {
        return identifiedAmmo;
    }

    default public void syncToClient(ServerPlayer player, UUID id) {
        NetworkChannel.sendToClient(player, new ClientSpellSync.Message(id, (CompoundTag)this.serializeNBT()));
    }

    default public void syncToServer(UUID id) {
        NetworkChannel.sendToServer(new ServerSpellSync.Message(id, (CompoundTag)this.serializeNBT()));
    }
}

