/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public interface IProjectileGahSpell<T extends Entity>
extends IGahSpell {
    @Override
    default public GahStats getStats(Player player) {
        return GahStats.spell(player, this.getProjectilePowerDamage(player), this.getProjectilePowerCoefficient(player), this.getProjectileMagicDamage(player), this.getProjectileMagicCoefficient(player));
    }

    @Override
    default public void onActivateSpell(Player player) {
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!this.canShoot(serverPlayer)) {
            return;
        }
        if (this.shoot(serverPlayer)) {
            this.onShootSuccess(serverPlayer);
        } else {
            this.onShootFailure(serverPlayer);
        }
    }

    @Override
    default public GahDamage onIndirectAttackEntity(ServerPlayer player, Entity attackingEntity, Entity target) {
        if (!(target instanceof LivingEntity)) {
            return GahDamage.ZERO;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (!attackingEntity.m_6095_().equals(this.getEntityType())) {
            return GahDamage.ZERO;
        }
        Entity projectile = attackingEntity;
        if (!this.canHurt((Player)player, projectile, livingTarget)) {
            return GahDamage.ZERO;
        }
        return this.onHit((Player)player, projectile, livingTarget);
    }

    @NotNull
    public EntityType<T> getEntityType();

    default public boolean canHurt(Player player, T projectile, LivingEntity target) {
        return true;
    }

    public float getProjectilePowerDamage(Player var1);

    public float getProjectilePowerCoefficient(Player var1);

    public float getProjectileMagicDamage(Player var1);

    public float getProjectileMagicCoefficient(Player var1);

    public boolean canShoot(ServerPlayer var1);

    public boolean shoot(ServerPlayer var1);

    default public GahDamage onHit(Player player, T projectile, LivingEntity target) {
        GahStats spellStats = this.getStats(player);
        GahCombat combat = new GahCombat(spellStats);
        return combat.calculateDamage((Entity)target);
    }

    default public void onShootSuccess(ServerPlayer player) {
    }

    default public void onShootFailure(ServerPlayer player) {
    }

    default public Optional<T> shootTargetedProjectile(Supplier<T> entityCreator, SpellTargetSetter<T> targetSetter, Player player, double distance) {
        boolean willSpawn;
        Optional<Either<LivingEntity, BlockPos>> hit = WorldUtils.findFirstHit((LivingEntity)player, distance);
        boolean bl = willSpawn = hit.isPresent() && (hit.get().left().isPresent() || hit.get().right().isPresent());
        if (!willSpawn) {
            return Optional.empty();
        }
        Entity entity = (Entity)entityCreator.get();
        targetSetter.set(entity, hit.get());
        if (!player.m_9236_().m_7967_(entity)) {
            return Optional.empty();
        }
        return Optional.of(entity);
    }

    @FunctionalInterface
    public static interface SpellTargetSetter<T extends Entity> {
        public void set(T var1, Either<LivingEntity, BlockPos> var2);
    }
}

