/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.GahLightningBolt;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LightningBoltSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<GahLightningBolt> {
    public static final UUID ID = UUID.fromString("6384ce6f-d529-424a-b486-443947b524cd");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("lightning_bolt").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("lightning_bolt").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.lightning_bolt_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.lightning_bolt_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(8.0f) - TimeUtils.secondsToTicks(0.2f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
        this.updateCooldown();
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 2.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 1.0f + 0.25f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        IProjectileGahSpell.SpellTargetSetter<GahLightningBolt> targetSetter = (e, h) -> {
            if (h.left().isPresent()) {
                e.setTarget((Entity)h.left().get());
            } else if (h.right().isPresent()) {
                e.setTargetBlock((BlockPos)h.right().get());
            }
        };
        return this.shootTargetedProjectile(() -> new GahLightningBolt((LivingEntity)player, player.m_9236_()), targetSetter, (Player)player, 15.0).isPresent();
    }

    @Override
    @NotNull
    public EntityType<GahLightningBolt> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.GAH_LIGHTNING_BOLT.get();
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
        EntityUtils.swing(player);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }
}

