/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.Meteor;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MeteorSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<Meteor> {
    public static final UUID ID = UUID.fromString("c0060d45-d7ca-4578-a8ff-768cf3fcd48a");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("meteor").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("meteor").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.meteor_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.meteor_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(18.0f) - TimeUtils.secondsToTicks(0.3f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
        this.updateCooldown();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 1.0f + 0.25f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 2.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.25f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        IProjectileGahSpell.SpellTargetSetter<Meteor> targetSetter = (e, h) -> {
            BlockPos blockPos;
            if (h.left().isPresent()) {
                blockPos = ((LivingEntity)h.left().get()).m_20097_();
            } else if (h.right().isPresent()) {
                blockPos = (BlockPos)h.right().get();
            } else {
                return;
            }
            if (!WorldUtils.isNotAir(player.m_9236_(), blockPos)) {
                e.m_146884_(blockPos.m_252807_());
            } else {
                e.m_146884_(blockPos.m_6630_(6).m_252807_());
            }
        };
        Supplier<Meteor> meteorSupplier = () -> {
            Meteor meteor = new Meteor((Player)player, player.m_9236_());
            meteor.m_20334_(0.0, -0.5, 0.0);
            return meteor;
        };
        return this.shootTargetedProjectile(meteorSupplier, targetSetter, (Player)player, 20.0).isPresent();
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
        EntityUtils.swing(player);
    }

    @Override
    @NotNull
    public EntityType<Meteor> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.METEOR.get();
    }
}

