/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PortalJumpSpell
implements ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("457e0230-0915-4ec6-b61d-14a45d20cee6");
    private static final int JUMP_DISTANCE = 7;
    private final Cooldown cooldown = new Cooldown();

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("portal_jump").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("portal_jump").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.EMPTY;
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.portal_jump.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.portal_jump.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(14.0f);
    }

    @Override
    public void onJump(Player player) {
        ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{EntityUtils.isClientSide((Entity)player), player.m_5833_(), player.m_7500_(), player.m_20096_(), player.m_20072_(), !this.getCooldown().check((LivingEntity)player)});
        if (checks.stream().anyMatch(Boolean::booleanValue)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)serverPlayer.m_9236_();
        Vec3 newLoc = this.determineJumpLocation(player);
        boolean blockChecks = Lists.newArrayList((Object[])new BlockPos[]{WorldUtils.toBlockPos(newLoc), WorldUtils.toBlockPos(newLoc).m_7494_(), WorldUtils.toBlockPos(newLoc).m_7495_()}).stream().map(arg_0 -> ((ServerLevel)level).m_8055_(arg_0)).allMatch(state -> state.m_60795_() || !state.m_280555_());
        if (blockChecks) {
            this.teleport(serverPlayer, newLoc);
            return;
        }
        BlockPos blockHit = WorldUtils.raytraceBlockNoY((Entity)player, 7.0);
        BlockState blockState = level.m_8055_(blockHit);
        if (blockState.m_60795_() || !blockState.m_280555_()) {
            Vec3 newPos = new Vec3((double)blockHit.m_7495_().m_123341_(), player.m_20186_(), (double)blockHit.m_7495_().m_123343_());
            this.teleport(serverPlayer, newPos);
        }
    }

    private void teleport(ServerPlayer player, Vec3 location) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123771_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 10, 0.05, 0.05, 0.05, 0.25);
        player.m_6021_(location.f_82479_, location.f_82480_, location.f_82481_);
        player.m_183634_();
        level.m_8767_((ParticleOptions)ParticleTypes.f_123771_, location.m_7096_(), location.m_7098_(), location.m_7094_(), 10, 0.05, 0.05, 0.05, 0.25);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.MAGE_TELEPORT.get());
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
    }

    private Vec3 determineJumpLocation(Player player) {
        double playerX = player.m_20185_();
        double playerZ = player.m_20189_();
        double playerYawRadians = Math.toRadians(player.m_146908_());
        double xOffset = -7.0 * Math.sin(playerYawRadians);
        double zOffset = 7.0 * Math.cos(playerYawRadians);
        double newX = playerX + xOffset;
        double newY = player.m_20186_();
        double newZ = playerZ + zOffset;
        return new Vec3(newX, newY, newZ);
    }
}

