/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.PowerSlash;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSetProgressBar;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerSlashSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<PowerSlash> {
    public static final UUID ID = UUID.fromString("71363409-72a3-42bd-bf72-e8c104e3ef8e");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;
    private boolean charging = false;
    private int chargeTicks = 0;

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(6.0f) - TimeUtils.secondsToTicks(0.2f) * this.getSpellPoints();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.power_slash.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.power_slash.description", 2);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("power_slash").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("power_slash").overlay();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    @NotNull
    public EntityType<PowerSlash> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.POWER_SLASH.get();
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 5 + this.getSpellPoints();
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 1.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public GahDamage onHit(Player player, PowerSlash projectile, LivingEntity target) {
        GahStats fullPowerStats = this.getStats(player);
        GahStats stats = new GahStats.Builder().damage(fullPowerStats.strength() * projectile.getSize(), 0.0f).build();
        GahCombat combat = new GahCombat(stats);
        return combat.calculateDamage((Entity)target);
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return !Capabilities.serverPlayer(player).isSpellBlocked() && this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        NetworkChannel.sendToClient(player, new ClientSetProgressBar.Message(GahoodRPGClient.ProgressBarType.POWER_SLASH));
        this.chargeTicks = 0;
        this.charging = true;
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_POWER_SLASH_CHARGE.get());
        this.syncToClient(player, ID);
        return true;
    }

    @Override
    public void onReleaseSpell(Player player) {
        if (!this.charging) {
            return;
        }
        player.m_20256_(Vec3.f_82478_);
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        this.spawnSlash(player);
    }

    @Override
    public void onPlayerDeath(Player player, @Nullable Entity killer) {
        this.charging = false;
    }

    @Override
    public void onTick(Player player) {
        if (!this.charging) {
            return;
        }
        player.m_20256_(Vec3.f_82478_);
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        if (this.chargeTicks >= PowerSlash.MAX_CHARGE_TIME) {
            this.spawnSlash(player);
            return;
        }
        ++this.chargeTicks;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128379_("charging", this.charging);
        nbt.m_128405_("chargeTicks", this.chargeTicks);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        this.charging = nbt.m_128471_("charging");
        this.chargeTicks = nbt.m_128451_("chargeTicks");
    }

    private void spawnSlash(Player player) {
        float chargePercent = Math.min(1.0f, (float)this.chargeTicks / (float)PowerSlash.MAX_CHARGE_TIME);
        PowerSlash powerSlash = new PowerSlash((LivingEntity)player);
        powerSlash.setSize(chargePercent);
        powerSlash.shootFromEntity((LivingEntity)player, 0.5f / powerSlash.getSize(), 0.0f);
        player.m_9236_().m_7967_((Entity)powerSlash);
        this.getCooldown().reset((LivingEntity)player);
        this.charging = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EntityUtils.swing((ServerPlayer)player);
            EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_POWER_SLASH_RELEASE.get());
            NetworkChannel.sendToClient(serverPlayer, new ClientSetProgressBar.Message(GahoodRPGClient.ProgressBarType.NONE));
            this.syncToClient(serverPlayer, ID);
        }
    }
}

