/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.GahArrow;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class RainingArrowsSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<GahArrow> {
    public static final UUID ID = UUID.fromString("eb64da30-973b-4906-8777-f5ffc1cf6b8f");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("raining_arrows").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("raining_arrows").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.raining_arrows_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.raining_arrows_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(3.0f) - TimeUtils.secondsToTicks(0.1f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 2.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 1.0f + 0.2f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        Optional<BlockPos> blockPos = WorldUtils.raytraceBlock((Entity)player, 30.0).filter(pos -> WorldUtils.isNotAir(player.m_9236_(), pos));
        if (blockPos.isEmpty()) {
            this.getCooldown().setOverride();
            return false;
        }
        Vec3 arrowVec3 = WorldUtils.getBlockPosCenter(blockPos.get()).m_82520_(0.0, 8.0, 0.0);
        int radius = 2;
        LinkedList<Pair> queue = new LinkedList<Pair>();
        HashSet<Vec3> seen = new HashSet<Vec3>();
        ArrayList<Vec3> arrowLocations = new ArrayList<Vec3>();
        queue.offer(Pair.of((Object)0, (Object)arrowVec3));
        while (!queue.isEmpty()) {
            Vec3 nextLoc;
            Pair next = (Pair)queue.pop();
            if ((Integer)next.getLeft() > radius || seen.contains(nextLoc = (Vec3)next.getRight())) continue;
            seen.add(nextLoc);
            if (WorldUtils.isNotAir(player.m_9236_(), nextLoc)) continue;
            arrowLocations.add(nextLoc);
            for (int xO = -1; xO <= 1; ++xO) {
                for (int zO = -1; zO <= 1; ++zO) {
                    if (xO == 0 && zO == 0) continue;
                    Vec3 locToCheck = new Vec3(nextLoc.f_82479_ + (double)xO, nextLoc.f_82480_, nextLoc.f_82481_ + (double)zO);
                    queue.offer(Pair.of((Object)((Integer)next.getLeft() + 1), (Object)locToCheck));
                }
            }
        }
        arrowLocations.stream().map(loc -> new GahArrow((Player)player, (Vec3)loc)).forEach(arg_0 -> ((Level)player.m_9236_()).m_7967_(arg_0));
        return true;
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.RANGER_RAINING_ARROWS_SHOOT.get());
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
        EntityUtils.swing(player);
    }

    @Override
    @NotNull
    public EntityType<GahArrow> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.GAH_ARROW.get();
    }

    @Override
    public boolean canHurt(Player player, GahArrow projectile, LivingEntity target) {
        return !projectile.isAutoAttack();
    }
}

