/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.RangerRootingVine;
import com.dee12452.gahoodrpg.common.entities.projectile.RootingVine;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RootingVineSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<RootingVine> {
    public static final UUID ID = UUID.fromString("231678c0-72a4-437f-8f1c-924cd1956282");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("rooting_vine").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("rooting_vine").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.rooting_vine_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.rooting_vine_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(12.0f) - TimeUtils.secondsToTicks(0.15f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 1.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 1.0f + 0.325f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        RangerRootingVine rootingVine = new RangerRootingVine((Player)player, TimeUtils.secondsToTicks(3.0f) + TimeUtils.secondsToTicks(0.25f) * this.getSpellPoints());
        rootingVine.shootFromEntity((LivingEntity)player, 1.0f, 0.0f);
        return player.m_9236_().m_7967_((Entity)rootingVine);
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.RANGER_ROOTING_VINE_SHOOT.get());
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
        EntityUtils.swing(player);
    }

    @Override
    @NotNull
    public EntityType<RootingVine> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.ROOTING_VINE.get();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }
}

