/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.GuardianShield;
import com.dee12452.gahoodrpg.common.items.weapons.GahShieldItem;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class ShieldThrowSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<GuardianShield> {
    public static final UUID ID = UUID.fromString("89bc404e-af2b-447e-9e54-e951845306a9");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(5.0f);
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.shield_throw_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.shield_throw_spell.description", 2);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("shield_throw").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("shield_throw").overlay();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    @NotNull
    public EntityType<GuardianShield> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.GUARDIAN_SHIELD.get();
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 2.0f + 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 1.0f + 0.15f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(final ServerPlayer player) {
        final ItemStack shieldStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!(shieldStack.m_41720_() instanceof ShieldItem)) {
            return false;
        }
        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        GuardianShield shieldProjectile = new GuardianShield((LivingEntity)player){

            @Override
            protected void m_5790_(@NotNull EntityHitResult result) {
                super.m_5790_(result);
                this.restoreShield();
                ShieldThrowSpell.this.getCooldown().forceReady((LivingEntity)player);
                EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_SHIELD_THROW_HIT.get());
                ShieldThrowSpell.this.syncToClient(player, ID);
            }

            @Override
            protected void m_8060_(@NotNull BlockHitResult result) {
                super.m_8060_(result);
                EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_SHIELD_THROW_MISS.get());
                this.restoreShield();
            }

            private void restoreShield() {
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, shieldStack);
                } else {
                    player.m_150109_().m_36054_(shieldStack);
                }
            }
        };
        Item item = shieldStack.m_41720_();
        if (item instanceof GahShieldItem) {
            GahShieldItem shieldItem = (GahShieldItem)item;
            shieldProjectile.setItem(shieldItem);
        }
        shieldProjectile.setAnimationState(GuardianShield.AnimationState.SPIN);
        shieldProjectile.shootFromEntity((LivingEntity)player, 1.25f, 0.0f);
        return player.m_9236_().m_7967_((Entity)shieldProjectile);
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_SHIELD_THROW.get());
        this.syncToClient(player, ID);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }
}

