/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;

public class SwordBarrageSpell
implements IGahSpell {
    public static final UUID ID = UUID.fromString("27e16ee8-2f23-4568-beae-2ff34eb85e9d");
    private static final AttributeModifier ATTACK_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("c1227163-1ae6-4da4-a7d1-08c91020df66"), "sword_barrage_attack_range_modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private int procs = 0;

    @Override
    public void onEnable(Player player) {
        Optional<AttributeInstance> attackRangeAttribute = Optional.ofNullable(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()));
        if (attackRangeAttribute.isEmpty()) {
            return;
        }
        attackRangeAttribute.get().m_22118_(ATTACK_RANGE_MODIFIER);
    }

    @Override
    public void onDisable(Player player) {
        Optional<AttributeInstance> attackRangeAttribute = Optional.ofNullable(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()));
        if (attackRangeAttribute.isEmpty()) {
            return;
        }
        attackRangeAttribute.get().m_22120_(ATTACK_RANGE_MODIFIER.m_22209_());
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.sword_barrage_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.sword_barrage_spell.description", 2);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("sword_barrage").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("sword_barrage").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        GahStats stats = GahStats.player(player);
        return new GahStats.Builder().damage(stats.strength() * 1.5f, 0.0f).build();
    }

    @Override
    public GahDamage onAttackEntity(ServerPlayer player, Entity target) {
        GahCombat combat = GahCombat.player((Player)player);
        GahDamage baseDamage = combat.calculatePowerDamage(target);
        if (this.procs < 2) {
            ++this.procs;
            return baseDamage;
        }
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_SWORD_BARRAGE_DING.get());
        this.procs = 0;
        return new GahDamage(baseDamage.powerDamage() * 1.5f, 0.0f);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("procs", this.procs);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.procs = nbt.m_128451_("procs");
    }
}

