/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ThornShieldSpell
implements ILevelingGahSpell,
ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("6ab422e0-5247-4ab2-b831-b6c2b844c27e");
    private static final int COOLDOWN_TICKS = 5;
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.thorn_shield_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.thorn_shield_spell.description")});
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("thorn_shield").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("thorn_shield").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.spell(player, 0.0f, 0.0f, 1.0f + 0.5f * (float)this.getSpellPoints(), 1.0f + 0.1f * (float)this.getSpellPoints());
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return 5L;
    }

    @Override
    public float onShieldBlock(ServerPlayer player, Entity attacker) {
        if (!this.getCooldown().checkAndReset((LivingEntity)player)) {
            return 0.0f;
        }
        GahStats stats = this.getStats((Player)player);
        GahCombat combat = new GahCombat(stats);
        GahDamage damage = combat.calculateDamage(attacker);
        attacker.m_6469_(GahDamageSource.direct((Entity)player, (Entity)player, damage), damage.total());
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_THORN_SHIELD_HIT.get());
        return 0.0f;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }
}

