/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.Twister;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TwisterSpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<Twister> {
    public static final UUID ID = UUID.fromString("89c25b3c-a878-484c-8550-4bcc546a0249");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("meteor").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("meteor").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.twister_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.twister_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(5.0f) - TimeUtils.secondsToTicks(0.3f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
        this.updateCooldown();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 1.0f + 0.25f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.5f * (float)this.getSpellPoints();
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.25f * (float)this.getSpellPoints();
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        Level level = player.m_9236_();
        Twister twister = new Twister((LivingEntity)player);
        twister.m_6034_(player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_());
        twister.shootFromEntity((LivingEntity)player, 0.5f, 0.0f);
        Vec3 prevDelta = twister.m_20184_();
        twister.m_20334_(prevDelta.f_82479_, 0.0, prevDelta.f_82481_);
        return level.m_7967_((Entity)twister);
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
        EntityUtils.swing(player);
    }

    @Override
    @NotNull
    public EntityType<Twister> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.TWISTER.get();
    }
}

