/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.entities.projectile.GahArrow;
import com.dee12452.gahoodrpg.common.items.Items;
import com.dee12452.gahoodrpg.common.items.weapons.GahBowItem;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class UnlimitedArrowsSpell
implements IGahSpell {
    public static final UUID ID = UUID.fromString("44f2bbb4-c5e4-42e5-a9a0-59c3af8dcfe9");

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("raining_arrows").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("raining_arrows").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return new GahStats.Builder().strength(GahStats.player(player).strength()).build();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.unlimited_arrows.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.unlimited_arrows.description")});
    }

    @Override
    public GahDamage onIndirectAttackEntity(ServerPlayer player, Entity attackingEntity, Entity target) {
        GahArrow arrow;
        if (!(attackingEntity instanceof GahArrow) || !(arrow = (GahArrow)attackingEntity).isAutoAttack()) {
            return GahDamage.ZERO;
        }
        GahStats stats = this.getStats((Player)player);
        GahCombat combat = new GahCombat(stats);
        return new GahDamage(combat.calculatePowerDamage(target).powerDamage() / 2.0f, 0.0f);
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    @Override
    public ItemStack findAmmo(ServerPlayer player, ItemStack weapon, ItemStack identifiedAmmo) {
        if (!(weapon.m_41720_() instanceof BowItem)) {
            return identifiedAmmo;
        }
        return new ItemStack((ItemLike)Items.GAH_ARROW.get());
    }

    @Override
    public void onItemUse(Player player, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof GahBowItem) {
            GahBowItem bowItem = (GahBowItem)item;
            bowItem.setShootAnimation(player);
        }
    }
}

