/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ValiantChargeSpell
implements ILevelingGahSpell,
ICooldownGahSpell {
    public static final UUID ID = UUID.fromString("8d1a1d77-5b4b-4db1-b242-b6f45273b0ed");
    private static final double CHARGE_SPEED = 1.25;
    private static final int CHARGE_TICK_DURATION = TimeUtils.secondsToTicks(1.0f);
    private static final AttributeModifier CHARGE_KNOCKBACK_MODIFIER = new AttributeModifier(UUID.fromString("0f94d308-f3a4-46fa-9d4e-9d7fa6708bfb"), "valiant_charge_knockback_modifier", 0.7, AttributeModifier.Operation.ADDITION);
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;
    private boolean charging = false;
    private int chargeTicks = 0;
    private Vec3 chargeDirection = Vec3.f_82478_;
    private final Set<UUID> hitEntities = new HashSet<UUID>();

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.valiant_charge_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.valiant_charge_spell.description", 2);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("valiant_charge").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("valiant_charge").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.spell(player, 0.5f + 0.5f * (float)this.getSpellPoints(), 1.0f + 0.05f * (float)this.getSpellPoints(), 0.5f + 0.5f * (float)this.getSpellPoints(), 1.0f + 0.05f * (float)this.getSpellPoints());
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(10.0f) - TimeUtils.secondsToTicks(0.5f) * this.getSpellPoints();
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128405_("chargeTicks", this.chargeTicks);
        nbt.m_128379_("charging", this.charging);
        nbt.m_128347_("chargeDirectionX", this.chargeDirection.f_82479_);
        nbt.m_128347_("chargeDirectionY", this.chargeDirection.f_82480_);
        nbt.m_128347_("chargeDirectionZ", this.chargeDirection.f_82481_);
        nbt.m_128405_("hitEntitiesSize", this.hitEntities.size());
        int idx = 0;
        for (UUID id : this.hitEntities) {
            nbt.m_128362_(String.format("hitEntity%d", idx), id);
            ++idx;
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        this.chargeTicks = nbt.m_128451_("chargeTicks");
        this.charging = nbt.m_128471_("charging");
        double chargeDirectionX = nbt.m_128459_("chargeDirectionX");
        double chargeDirectionY = nbt.m_128459_("chargeDirectionY");
        double chargeDirectionZ = nbt.m_128459_("chargeDirectionZ");
        this.chargeDirection = new Vec3(chargeDirectionX, chargeDirectionY, chargeDirectionZ);
        this.hitEntities.clear();
        int hitEntitiesSize = nbt.m_128451_("hitEntitiesSize");
        for (int idx = 0; idx < hitEntitiesSize; ++idx) {
            this.hitEntities.add(nbt.m_128342_(String.format("hitEntity%d", idx)));
        }
    }

    @Override
    public void onActivateSpell(Player player) {
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        if (this.charging || !this.getCooldown().checkAndReset((LivingEntity)player)) {
            return;
        }
        this.hitEntities.clear();
        this.chargeTicks = 0;
        this.chargeDirection = player.m_20154_();
        this.charging = true;
        Optional<AttributeInstance> knockbackAttribute = Optional.ofNullable(player.m_21051_(Attributes.f_22282_));
        knockbackAttribute.ifPresent(attr -> attr.m_22118_(CHARGE_KNOCKBACK_MODIFIER));
        player.m_20331_(true);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_VALIANT_CHARGE.get());
        this.syncToClient((ServerPlayer)player, ID);
    }

    @Override
    public void onTick(Player player) {
        if (!this.charging) {
            return;
        }
        if (this.chargeTicks > CHARGE_TICK_DURATION) {
            this.chargeTicks = 0;
            this.chargeDirection = Vec3.f_82478_;
            this.charging = false;
            if (!EntityUtils.isClientSide((Entity)player)) {
                Optional<AttributeInstance> knockbackAttribute = Optional.ofNullable(player.m_21051_(Attributes.f_22282_));
                knockbackAttribute.ifPresent(attr -> attr.m_22120_(CHARGE_KNOCKBACK_MODIFIER.m_22209_()));
                player.m_20331_(false);
            }
            return;
        }
        if (EntityUtils.isClientSide((Entity)player)) {
            player.m_20334_(this.chargeDirection.f_82479_ * 1.25, player.m_20184_().f_82480_, this.chargeDirection.f_82481_ * 1.25);
        } else {
            this.serverTick((ServerPlayer)player);
        }
        ++this.chargeTicks;
    }

    private void serverTick(ServerPlayer player) {
        AABB chargeHitbox = player.m_20191_().m_82400_(1.5);
        player.m_9236_().m_45933_((Entity)player, chargeHitbox).stream().filter(e -> e instanceof LivingEntity && !(e instanceof ServerPlayer)).forEach(e -> this.hitEntity(player, (LivingEntity)e));
    }

    private void hitEntity(ServerPlayer player, LivingEntity target) {
        if (this.hitEntities.contains(target.m_20148_())) {
            return;
        }
        this.hitEntities.add(target.m_20148_());
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            mob.m_6710_((LivingEntity)player);
        }
        GahCombat combat = new GahCombat(this.getStats((Player)player));
        GahDamage damage = combat.calculateDamage((Entity)target);
        target.m_6469_(GahDamageSource.direct((Entity)player, (Entity)player, damage), damage.total());
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_VALIANT_CHARGE_HIT.get());
    }
}

