/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.ILevelingGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.WarriorSkull;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WarCrySpell
implements ILevelingGahSpell,
ICooldownGahSpell,
IProjectileGahSpell<WarriorSkull> {
    public static final UUID ID = UUID.fromString("e2df3c5b-69be-499b-8c86-3bb5ed08dc68");
    private final Cooldown cooldown = new Cooldown();
    private int spellPoints = 0;
    private final Set<UUID> activeSkulls = new HashSet<UUID>();

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(23.0f) - TimeUtils.secondsToTicks(0.25f) * this.getSpellPoints();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.war_cry.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return this.loadDescriptions("spell.gahoodrpg.war_cry.description", 3);
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("war_cry").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("war_cry").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        return GahStats.EMPTY;
    }

    @Override
    public int getSpellPoints() {
        return this.spellPoints;
    }

    @Override
    public void setSpellPoints(int spellPoints) {
        this.spellPoints = spellPoints;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("level", (Tag)ILevelingGahSpell.super.serializeNBT());
        nbt.m_128365_("cooldown", (Tag)ICooldownGahSpell.super.serializeNBT());
        nbt.m_128405_("activeSkullsSize", this.activeSkulls.size());
        int idx = 0;
        for (UUID id : this.activeSkulls) {
            nbt.m_128362_(String.format("activeSkull%d", idx), id);
            ++idx;
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ILevelingGahSpell.super.deserializeNBT(nbt.m_128469_("level"));
        ICooldownGahSpell.super.deserializeNBT(nbt.m_128469_("cooldown"));
        this.activeSkulls.clear();
        int activeSkullsSize = nbt.m_128451_("activeSkullsSize");
        for (int idx = 0; idx < activeSkullsSize; ++idx) {
            this.activeSkulls.add(nbt.m_128342_(String.format("activeSkull%d", idx)));
        }
    }

    @Override
    @NotNull
    public EntityType<WarriorSkull> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.WARRIOR_SKULL.get();
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.0f;
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.0f;
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return !Capabilities.serverPlayer(player).isSpellBlocked() && this.getCooldown().check((LivingEntity)player);
    }

    @Override
    public Optional<GahDamage> onEntityAttack(ServerPlayer player, Entity attacker, GahDamage totalDamageDealt) {
        if (!attacker.m_19880_().contains(this.createWarCryTag((Player)player))) {
            return ICooldownGahSpell.super.onEntityAttack(player, attacker, totalDamageDealt);
        }
        return Optional.empty();
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        ArrayList<WarriorSkull> skulls = new ArrayList<WarriorSkull>();
        float playerYRot = player.m_146908_();
        float yRotMod = -25.0f;
        for (int idx = 0; idx < 3; ++idx) {
            WarriorSkull skull = new WarriorSkull((LivingEntity)player, TimeUtils.secondsToTicks(1.0f));
            skull.m_37251_((Entity)player, player.m_146909_(), playerYRot + (-25.0f + (float)(idx * 25)), 0.0f, 0.5f, 0.0f);
            skull.setAnimationState(WarriorSkull.WarriorSkullAnimationState.SPIN);
            skull.setEntityState(WarriorSkull.WarriorSkullState.SHOT);
            if (!level.m_7967_((Entity)skull)) {
                skulls.forEach(Entity::m_146870_);
                return false;
            }
            skulls.add(skull);
        }
        return true;
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.WARRIOR_WAR_CRY.get());
        this.getCooldown().reset((LivingEntity)player);
        this.syncToClient(player, ID);
        List<Entity> entitiesInView = EntityUtils.raytraceEntitiesInView((LivingEntity)player, 5.0);
        for (Entity entity : entitiesInView) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)entity;
            WarriorSkull skull = new WarriorSkull((LivingEntity)player);
            skull.attachTo(target, e -> this.removeWarCryTag((Player)player, (Entity)e), this.getAttachTicks());
            this.addWarCryTag((Player)player, (Entity)target);
            if (!player.m_9236_().m_7967_((Entity)skull)) continue;
            this.activeSkulls.add(skull.m_20148_());
        }
    }

    @Override
    public void onTick(Player player) {
        if (EntityUtils.isClientSide((Entity)player)) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        HashSet<UUID> skullsToRemove = new HashSet<UUID>();
        for (UUID skullId : this.activeSkulls) {
            Entity skull = level.m_8791_(skullId);
            if (skull != null && skull.m_6084_()) continue;
            skullsToRemove.add(skullId);
        }
        skullsToRemove.forEach(this.activeSkulls::remove);
    }

    public GahDamage applyWarCryDamage(Player player, Entity target, GahDamage damage) {
        if (damage.isZero()) {
            return GahDamage.ZERO;
        }
        if (!this.hasWarCryTag(player, target)) {
            return damage;
        }
        return new GahDamage(damage.powerDamage() * (1.0f + 0.1f * (float)this.getSpellPoints()), damage.magicDamage());
    }

    private int getAttachTicks() {
        return TimeUtils.secondsToTicks(3.5f) + TimeUtils.secondsToTicks(0.25f) * this.getSpellPoints();
    }

    private String createWarCryTag(Player player) {
        return String.format("warCry%d", player.m_19879_());
    }

    private boolean hasWarCryTag(Player player, Entity entity) {
        return entity.m_19880_().contains(this.createWarCryTag(player));
    }

    private void addWarCryTag(Player player, Entity entity) {
        entity.m_20049_(this.createWarCryTag(player));
    }

    private void removeWarCryTag(Player player, Entity entity) {
        entity.m_20137_(this.createWarCryTag(player));
    }
}

