/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.capabilities.spell.ICooldownGahSpell;
import com.dee12452.gahoodrpg.common.capabilities.spell.IProjectileGahSpell;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.projectile.WindSlash;
import com.dee12452.gahoodrpg.common.items.weapons.tier0.VanillaWandItem;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WindslashSpell
implements ICooldownGahSpell,
IProjectileGahSpell<WindSlash> {
    public static final UUID ID = UUID.fromString("05e448d1-fc33-415d-9c58-bb89a491a1db");
    private final Cooldown cooldown = new Cooldown().setIgnoreAlacrity();

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("windslash").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("windslash").overlay();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.windslash_spell.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.windslash_spell.description")});
    }

    @Override
    public Cooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public long getCooldownDelay() {
        return TimeUtils.secondsToTicks(1.0f);
    }

    @Override
    public float getProjectilePowerDamage(Player player) {
        return 0.5f;
    }

    @Override
    public float getProjectilePowerCoefficient(Player player) {
        return 0.25f;
    }

    @Override
    public float getProjectileMagicDamage(Player player) {
        return 0.5f;
    }

    @Override
    public float getProjectileMagicCoefficient(Player player) {
        return 0.25f;
    }

    @Override
    public void onItemUse(Player player, ItemStack stack) {
        this.onActivateSpell(player);
    }

    @Override
    public boolean canShoot(ServerPlayer player) {
        return this.getCooldown().check((LivingEntity)player) && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof VanillaWandItem;
    }

    @Override
    public boolean shoot(ServerPlayer player) {
        Level level = player.m_9236_();
        WindSlash windSlash = new WindSlash((Player)player, level);
        windSlash.shootFromEntity((LivingEntity)player, 1.5f, 0.0f);
        return level.m_7967_((Entity)windSlash);
    }

    @Override
    public void onShootSuccess(ServerPlayer player) {
        this.getCooldown().reset((LivingEntity)player);
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.MAGE_WINDSLASH_SHOOT.get());
        EntityUtils.swing(player);
        this.syncToClient(player, ID);
    }

    @Override
    @NotNull
    public EntityType<WindSlash> getEntityType() {
        return (EntityType)ProjectileEntityRegistry.WIND_SLASH.get();
    }
}

