/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.capabilities.spell;

import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.entities.living.RangerWolf;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.Nullable;

public class WolfPackSpell
implements IGahSpell {
    public static final UUID ID = UUID.fromString("a97fc09f-093f-4096-a6e5-04ead01662ce");
    private static final float PLAYER_WOLF_DISTANCE_THRESHOLD = 75.0f;
    @Nullable
    private UUID wolfId;

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocationBuilder("wolf_pack").icon();
    }

    @Override
    public ResourceLocation getOverlay() {
        return new ResourceLocationBuilder("wolf_pack").overlay();
    }

    @Override
    public GahStats getStats(Player player) {
        GahStats playerStats = GahStats.player(player);
        return new GahStats.Builder().damage(playerStats.strength() / 2.0f, 0.0f).build();
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"spell.gahoodrpg.wolf_pack.name");
    }

    @Override
    public List<Component> getDescriptions() {
        return Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"spell.gahoodrpg.wolf_pack.description")});
    }

    @Override
    public void onEnable(Player player) {
        this.respawnWolf(player);
    }

    @Override
    public void onDisable(Player player) {
        this.removeExistingWolf(player);
    }

    @Override
    public void onDimensionChange(ServerPlayer player) {
        this.respawnWolf((Player)player);
    }

    @Override
    public GahDamage onIndirectAttackEntity(ServerPlayer player, Entity attackingEntity, Entity target) {
        if (!(attackingEntity instanceof RangerWolf)) {
            return GahDamage.ZERO;
        }
        GahCombat combat = new GahCombat(this.getStats((Player)player));
        GahDamage damage = combat.calculatePowerDamage(target);
        return new GahDamage(damage.powerDamage() / 2.0f, damage.magicDamage() / 2.0f);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        Optional.ofNullable(this.wolfId).ifPresent(id -> nbt.m_128362_("wolfId", id));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("wolfId")) {
            this.wolfId = nbt.m_128342_("wolfId");
        }
    }

    @Override
    public void onTick(Player player) {
        if (EntityUtils.isClientSide((Entity)player) || player.f_19797_ % 20 != 0) {
            return;
        }
        Optional<ServerLevel> playerLevel = EntityUtils.getServerLevel((LivingEntity)player);
        Optional wolf = this.findWolves(player, (ServerLevel)player.m_9236_()).stream().findFirst();
        List<Item> heldItems = List.of(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_(), player.m_21120_(InteractionHand.OFF_HAND).m_41720_());
        boolean holdingPickaxe = heldItems.stream().anyMatch(item -> item instanceof PickaxeItem);
        if (holdingPickaxe) {
            wolf.ifPresent(w -> this.removeExistingWolf(player));
            return;
        }
        if (wolf.isEmpty()) {
            this.respawnWolf(player);
            return;
        }
        if (playerLevel.orElseThrow() != EntityUtils.getServerLevel((LivingEntity)wolf.get()).orElseThrow()) {
            this.respawnWolf(player);
            return;
        }
        if (((RangerWolf)((Object)wolf.get())).m_20270_((Entity)player) > 75.0f) {
            this.respawnWolf(player);
            return;
        }
    }

    private void respawnWolf(Player player) {
        this.removeExistingWolf(player);
        Optional<ServerLevel> level = EntityUtils.getServerLevel((LivingEntity)player);
        if (level.isEmpty()) {
            return;
        }
        this.spawnWolf(player, level.get());
    }

    private void spawnWolf(Player player, ServerLevel level) {
        RangerWolf wolf = (RangerWolf)((EntityType)LivingEntityRegistry.RANGER_WOLF.get()).m_262496_(level, player.m_20183_(), MobSpawnType.MOB_SUMMONED);
        if (wolf == null) {
            return;
        }
        wolf.m_21828_(player);
        level.m_7967_((Entity)wolf);
        this.wolfId = wolf.m_20148_();
    }

    private void removeExistingWolf(Player player) {
        Optional<ServerLevel> level = EntityUtils.getServerLevel((LivingEntity)player);
        if (level.isEmpty()) {
            return;
        }
        this.findWolves(player, level.get()).forEach(Entity::m_146870_);
        this.wolfId = null;
    }

    private List<RangerWolf> findWolves(Player player, ServerLevel level) {
        ArrayList<RangerWolf> wolves = new ArrayList<RangerWolf>();
        MinecraftServer server = level.m_7654_();
        for (ServerLevel otherLevel : server.m_129785_()) {
            List playerWolves = otherLevel.m_143280_(EntityTypeTest.m_156916_(RangerWolf.class), wolf -> Objects.equals(wolf.m_21805_(), player.m_20148_()));
            wolves.addAll(playerWolves);
        }
        return wolves;
    }
}

