/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.combat;

import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class GahAttribute
extends Attribute {
    private static final DeferredRegister<Attribute> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"gahoodrpg");
    private static final List<RegistryObject<Attribute>> GAH_ATTRIBUTES = new ArrayList<RegistryObject<Attribute>>();
    public static final RegistryObject<Attribute> STRENGTH = GahAttribute.register("gah_power_damage", () -> new GahAttribute("attribute.name.generic.gah_power_damage", amount -> GahAttributeModifiers.strength(amount.floatValue())));
    public static final RegistryObject<Attribute> INTELLIGENCE = GahAttribute.register("gah_magic_damage", () -> new GahAttribute("attribute.name.generic.gah_magic_damage", amount -> GahAttributeModifiers.intelligence(amount.floatValue())));
    public static final RegistryObject<Attribute> TOUGHNESS = GahAttribute.register("gah_power_resist", () -> new GahAttribute("attribute.name.generic.gah_power_resist", amount -> GahAttributeModifiers.toughness(amount.floatValue())));
    public static final RegistryObject<Attribute> TOUGHNESS_PERCENT = GahAttribute.register("gah_power_resist_percent", () -> new GahAttribute("attribute.name.generic.gah_power_resist_percent", amount -> GahAttributeModifiers.toughness(amount.floatValue())));
    public static final RegistryObject<Attribute> AEGIS = GahAttribute.register("gah_magic_resist", () -> new GahAttribute("attribute.name.generic.gah_magic_resist", amount -> GahAttributeModifiers.aegis(amount.floatValue())));
    public static final RegistryObject<Attribute> AEGIS_PERCENT = GahAttribute.register("gah_magic_resist_percent", () -> new GahAttribute("attribute.name.generic.gah_magic_resist_percent", amount -> GahAttributeModifiers.aegis(amount.floatValue())));
    public static final RegistryObject<Attribute> GAH_EXPERIENCE = GahAttribute.register("gah_experience", () -> new GahAttribute("attribute.name.generic.gah_experience", amount -> GahAttributeModifiers.experience(amount.floatValue())));
    public static final RegistryObject<Attribute> DEXTERITY = GahAttribute.register("gah_dexterity", () -> new GahAttribute("attribute.name.generic.gah_dexterity", amount -> GahAttributeModifiers.dexterity(amount.floatValue())));
    public static final RegistryObject<Attribute> VITALITY = GahAttribute.register("gah_vitality", () -> new GahAttribute("attribute.name.generic.gah_vitality", amount -> GahAttributeModifiers.vitality(amount.floatValue())));
    public static final RegistryObject<Attribute> ALACRITY = GahAttribute.register("gah_alacrity", () -> new GahAttribute("attribute.name.generic.gah_alacrity", amount -> GahAttributeModifiers.alacrity(amount.floatValue())));
    private final Function<Double, AttributeModifier> modifierCreator;

    public static List<RegistryObject<Attribute>> getAllGahAttributes() {
        return GAH_ATTRIBUTES;
    }

    private static RegistryObject<Attribute> register(String name, Supplier<Attribute> attributeCreator) {
        RegistryObject attribute = REGISTER.register(name, attributeCreator);
        GAH_ATTRIBUTES.add((RegistryObject<Attribute>)attribute);
        return attribute;
    }

    public GahAttribute(String id, Function<Double, AttributeModifier> modifierCreator) {
        super(id, 0.0);
        this.m_22084_(true);
        this.modifierCreator = modifierCreator;
    }

    public AttributeModifier createAddModifier(double amount) {
        return this.modifierCreator.apply(amount);
    }

    public void addModifier(LivingEntity entity, double amount) {
        AttributeInstance instance = Optional.ofNullable(entity.m_21051_((Attribute)this)).orElseThrow();
        instance.m_22118_(this.modifierCreator.apply(amount));
    }

    public void removeModifiers(LivingEntity entity) {
        AttributeInstance instance = Optional.ofNullable(entity.m_21051_((Attribute)this)).orElseThrow();
        instance.m_22132_();
    }

    public static DeferredRegister<Attribute> getRegister() {
        return REGISTER;
    }
}

