/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.combat;

import com.dee12452.gahoodrpg.common.combat.GahAttribute;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.utils.ColorUtils;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class GahAttributeModifiers {
    public static final Map<Attribute, GahAttributeModifierCreator> GAH_ATTRIBUTE_MODIFIERS = new HashMap<Attribute, GahAttributeModifierCreator>(){
        {
            this.put((Attribute)GahAttribute.STRENGTH.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.strength(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.strength();
                }
            });
            this.put((Attribute)GahAttribute.INTELLIGENCE.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.intelligence(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.intelligence();
                }
            });
            this.put((Attribute)GahAttribute.TOUGHNESS.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.toughness(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.toughness();
                }
            });
            this.put((Attribute)GahAttribute.TOUGHNESS_PERCENT.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.toughnessPercent(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.toughnessPercent();
                }
            });
            this.put((Attribute)GahAttribute.AEGIS.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.aegis(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.aegis();
                }
            });
            this.put((Attribute)GahAttribute.AEGIS_PERCENT.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.aegisPercent(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.aegisPercent();
                }
            });
            this.put((Attribute)GahAttribute.DEXTERITY.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.dexterity(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.dexterity();
                }
            });
            this.put((Attribute)GahAttribute.VITALITY.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.vitality(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.vitality();
                }
            });
            this.put((Attribute)GahAttribute.ALACRITY.get(), new GahAttributeModifierCreator(){

                @Override
                public AttributeModifier createModifier(float amount) {
                    return GahAttributeModifiers.alacrity(amount);
                }

                @Override
                public float getStatValue(GahStats stats) {
                    return stats.alacrity();
                }
            });
        }
    };

    private GahAttributeModifiers() {
    }

    public static AttributeModifier strength(float damage) {
        return new AttributeModifier(ID.STRENGTH, "attribute.gahoodrpg.modifier.damage.power", (double)damage, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier intelligence(float damage) {
        return new AttributeModifier(ID.INTELLIGENCE, "attribute.gahoodrpg.modifier.damage.magic", (double)damage, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier toughness(float resist) {
        return new AttributeModifier(ID.TOUGHNESS, "attribute.gahoodrpg.modifier.resist.power", (double)resist, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier toughnessPercent(float resist) {
        return new AttributeModifier(ID.TOUGHNESS_PERCENT, "attribute.gahoodrpg.modifier.resist.power.percent", (double)resist, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier aegis(float resist) {
        return new AttributeModifier(ID.AEGIS, "attribute.gahoodrpg.modifier.resist.magic", (double)resist, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier aegisPercent(float resist) {
        return new AttributeModifier(ID.AEGIS_PERCENT, "attribute.gahoodrpg.modifier.resist.magic.percent", (double)resist, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier experience(float amount) {
        return new AttributeModifier(ID.EXPERIENCE, "attribute.gahoodrpg.modifier.experience", (double)amount, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier dexterity(float amount) {
        return new AttributeModifier(ID.DEXTERITY, "attribute.gahoodrpg.modifier.dexterity", (double)amount, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier vitality(float amount) {
        return new AttributeModifier(ID.VITALITY, "attribute.gahoodrpg.modifier.vitality", (double)amount, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier alacrity(float amount) {
        return new AttributeModifier(ID.ALACRITY, "attribute.gahoodrpg.modifier.alacrity", (double)amount, AttributeModifier.Operation.ADDITION);
    }

    public static float getGahStatAmount(ItemStack stack, EquipmentSlot slot, Attribute attribute) {
        return (float)stack.m_41638_(slot).get((Object)attribute).stream().filter(modifier -> modifier.m_22217_() == AttributeModifier.Operation.ADDITION).map(AttributeModifier::m_22218_).mapToDouble(amount -> amount).sum();
    }

    public static void colorizeGahAttributeModifiers(List<Component> components) {
        Set<Attribute> formatKeys = ColorUtils.STAT_FORMATS.keySet();
        for (Component tooltip : components) {
            Object[] args;
            if (!(tooltip instanceof MutableComponent)) continue;
            MutableComponent mutableComponent = (MutableComponent)tooltip;
            ComponentContents componentContents = tooltip.m_214077_();
            if (!(componentContents instanceof TranslatableContents)) continue;
            TranslatableContents contents = (TranslatableContents)componentContents;
            for (Object arg : args = contents.m_237523_()) {
                MutableComponent c;
                ComponentContents componentContents2;
                if (!(arg instanceof MutableComponent) || !((componentContents2 = (c = (MutableComponent)arg).m_214077_()) instanceof TranslatableContents)) continue;
                TranslatableContents tc = (TranslatableContents)componentContents2;
                Optional<Attribute> statFormat = formatKeys.stream().filter(format -> format.m_22087_().contains(tc.m_237508_())).findFirst();
                if (!statFormat.isPresent()) continue;
                TextColor color = ColorUtils.STAT_FORMATS.get(statFormat.get());
                mutableComponent.m_6270_(tooltip.m_7383_().m_131148_(color));
            }
        }
    }

    public static void setStatModifiers(ItemStack stack, EquipmentSlot slot, GahStats stats) {
        Multimap originalModifiers = stack.m_41638_(slot);
        for (Map.Entry<Attribute, GahAttributeModifierCreator> gahModifiers : GAH_ATTRIBUTE_MODIFIERS.entrySet()) {
            GahAttributeModifierCreator modifierCreator = gahModifiers.getValue();
            GahAttributeModifiers.setStatModifier(stack, slot, gahModifiers.getKey(), modifierCreator.createModifier(modifierCreator.getStatValue(stats)));
        }
        GahAttributeModifiers.addVanillaModifiers(stack, slot, (Multimap<Attribute, AttributeModifier>)originalModifiers);
    }

    public static void addStatModifiers(ItemStack stack, EquipmentSlot slot, GahStats stats, List<Attribute> attributesToIgnore) {
        Multimap originalModifiers = stack.m_41638_(slot);
        for (Map.Entry<Attribute, GahAttributeModifierCreator> gahAttributeModifier : GAH_ATTRIBUTE_MODIFIERS.entrySet()) {
            Attribute attribute = gahAttributeModifier.getKey();
            if (attributesToIgnore.contains(attribute)) continue;
            GahAttributeModifierCreator modifierCreator = gahAttributeModifier.getValue();
            GahAttributeModifiers.addStatModifier(stack, slot, attribute, (Multimap<Attribute, AttributeModifier>)originalModifiers, modifierCreator.getStatValue(stats), modifierCreator::createModifier);
        }
        GahAttributeModifiers.addVanillaModifiers(stack, slot, (Multimap<Attribute, AttributeModifier>)originalModifiers);
    }

    private static void addVanillaModifiers(ItemStack stack, EquipmentSlot slot, Multimap<Attribute, AttributeModifier> originalModifiers) {
        List<Attribute> statModifiers = GahAttribute.getAllGahAttributes().stream().map(RegistryObject::get).toList();
        for (Map.Entry modifier : originalModifiers.entries()) {
            if (statModifiers.contains(modifier.getKey())) continue;
            AttributeModifier attributeModifier = (AttributeModifier)modifier.getValue();
            stack.m_41643_((Attribute)modifier.getKey(), attributeModifier, slot);
        }
    }

    private static void addStatModifier(ItemStack stack, EquipmentSlot slot, Attribute attribute, Multimap<Attribute, AttributeModifier> originalModifiers, float amount, Function<Float, AttributeModifier> creator) {
        if (originalModifiers.containsKey((Object)attribute)) {
            amount += (float)originalModifiers.get((Object)attribute).stream().filter(m -> m.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)).map(AttributeModifier::m_22218_).mapToDouble(Double::doubleValue).sum();
        }
        if (amount > 0.0f) {
            stack.m_41643_(attribute, creator.apply(Float.valueOf(amount)), slot);
        }
    }

    private static void setStatModifier(ItemStack stack, EquipmentSlot slot, Attribute attribute, AttributeModifier modifier) {
        if (modifier.m_22218_() > 0.0) {
            stack.m_41643_(attribute, modifier, slot);
        }
    }

    public static class ID {
        public static final UUID STRENGTH = UUID.fromString("9e8def3e-fe7b-42aa-ab71-758cb86b4979");
        public static final UUID INTELLIGENCE = UUID.fromString("1cb0adfd-d1c5-42dd-9f14-352f47b250be");
        public static final UUID TOUGHNESS = UUID.fromString("815ccf5d-61e1-4e37-8a07-ada367f8c5ff");
        public static final UUID TOUGHNESS_PERCENT = UUID.fromString("9bcb7dc9-7558-4b1a-b9a3-f35b8d0f1340");
        public static final UUID AEGIS = UUID.fromString("7f83fa2a-aae7-4447-916d-607cb21eebfa");
        public static final UUID AEGIS_PERCENT = UUID.fromString("3f0908a7-b354-4da9-ba0c-2be79a9635e5");
        public static final UUID EXPERIENCE = UUID.fromString("e169cd3a-7f5f-4509-a414-48642bdf9bc1");
        public static final UUID VITALITY = UUID.fromString("ec1ba510-4d67-4145-bcb0-63481833c4a5");
        public static final UUID DEXTERITY = UUID.fromString("32100489-44de-4408-a676-a5433c8e5e77");
        public static final UUID ALACRITY = UUID.fromString("7cae0da2-78d6-41e9-b820-a46b9ee46df7");

        private ID() {
        }
    }

    public static interface GahAttributeModifierCreator {
        public AttributeModifier createModifier(float var1);

        public float getStatValue(GahStats var1);
    }

    public static class Builder {
        private final ImmutableMultimap.Builder<Attribute, AttributeModifier> builder = new ImmutableMultimap.Builder();

        public Builder(Multimap<Attribute, AttributeModifier> defaults) {
            this.builder.putAll(defaults);
        }

        public Builder stats(GahStats gahStats) {
            GAH_ATTRIBUTE_MODIFIERS.entrySet().forEach(attMod -> this.put((GahAttribute)((Object)((Object)attMod.getKey())), ((GahAttributeModifierCreator)attMod.getValue()).getStatValue(gahStats)));
            return this;
        }

        public Multimap<Attribute, AttributeModifier> build() {
            return this.builder.build();
        }

        private void put(GahAttribute attribute, double amount) {
            if (amount <= 0.0) {
                return;
            }
            this.builder.put((Object)attribute, (Object)attribute.createAddModifier(amount));
        }
    }
}

