/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.combat;

import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageCalculator;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class GahCombat {
    private final GahStats attackerStats;

    public GahCombat(GahStats attackerStats) {
        this.attackerStats = attackerStats;
    }

    private GahCombat(Player player) {
        this(GahStats.player(player));
    }

    public static GahCombat player(Player player) {
        return new GahCombat(player);
    }

    public static GahCombat entity(Entity entity) {
        return new GahCombat(GahStats.of(entity));
    }

    public GahDamage calculateDamage(Entity target) {
        return this.calculatePowerDamage(target).add(this.calculateMagicDamage(target));
    }

    public GahDamage calculatePowerDamage(Entity target) {
        GahStats targetStats = GahStats.of(target);
        float amount = GahDamageCalculator.calculateGahDamage(this.attackerStats.strength(), targetStats.toughness(), targetStats.toughnessPercent());
        return new GahDamage(amount, 0.0f);
    }

    public GahDamage calculateMagicDamage(Entity target) {
        GahStats targetStats = GahStats.of(target);
        float amount = GahDamageCalculator.calculateGahDamage(this.attackerStats.intelligence(), targetStats.aegis(), targetStats.aegisPercent());
        return new GahDamage(0.0f, amount);
    }

    static float calculateDamage(GahStats attacker, GahStats target) {
        return Math.max(0.5f, GahDamageCalculator.calculateGahDamage(attacker.strength(), target.toughness(), target.toughnessPercent()) + GahDamageCalculator.calculateGahDamage(attacker.intelligence(), target.aegis(), target.aegisPercent()));
    }
}

