/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.combat;

import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class GahDamageSource
extends DamageSource {
    private static final ResourceLocation GAH_DAMAGE_RESOURCE_LOCATION = new ResourceLocation("gahoodrpg", "gah_damage");
    private static final ResourceLocation INDIRECT_GAH_DAMAGE_RESOURCE_LOCATION = new ResourceLocation("gahoodrpg", "indirect_gah_damage");
    private static final ResourceLocation GAH_POISON_RESOURCE_LOCATION = new ResourceLocation("gahoodrpg", "gah_poison");
    private final boolean isPowerDamage;
    private final boolean isMagicDamage;

    public GahDamageSource(Holder<DamageType> p_270818_, @Nullable Entity p_270162_, @Nullable Entity p_270115_, boolean isPowerDamage, boolean isMagicDamage) {
        super(p_270818_, p_270162_, p_270115_);
        this.isPowerDamage = isPowerDamage;
        this.isMagicDamage = isMagicDamage;
    }

    public GahDamageSource(Holder<DamageType> p_270818_, @Nullable Entity p_270162_, @Nullable Entity p_270115_, GahDamage damage) {
        this(p_270818_, p_270162_, p_270115_, damage.isPowerDamage(), damage.isMagicDamage());
    }

    public boolean isPowerDamage() {
        return this.isPowerDamage;
    }

    public boolean isMagicDamage() {
        return this.isMagicDamage;
    }

    public static DamageSource direct(Entity attacker, Entity directSource, GahDamage damage) {
        Registry<DamageType> registry = GahDamageSource.getRegistry(attacker);
        return new GahDamageSource(new GahDamageHolder<DamageType>(GAH_DAMAGE_RESOURCE_LOCATION, (DamageType)registry.m_7745_(GAH_DAMAGE_RESOURCE_LOCATION)), directSource, attacker, damage);
    }

    public static DamageSource indirect(Entity attacker, Entity directSource) {
        Registry<DamageType> registry = GahDamageSource.getRegistry(attacker);
        DamageType holder = Optional.ofNullable((DamageType)registry.m_7745_(INDIRECT_GAH_DAMAGE_RESOURCE_LOCATION)).orElseThrow();
        return new DamageSource(Holder.m_205709_((Object)holder), directSource, attacker);
    }

    public static DamageSource poison(LivingEntity target) {
        Registry<DamageType> registry = GahDamageSource.getRegistry((Entity)target);
        GahDamageHolder<DamageType> holder = new GahDamageHolder<DamageType>(GAH_POISON_RESOURCE_LOCATION, (DamageType)registry.m_7745_(GAH_POISON_RESOURCE_LOCATION));
        return new GahDamageSource(holder, null, null, false, true);
    }

    private static Registry<DamageType> getRegistry(@Nullable Entity entity) {
        return WorldUtils.getRegistryAccess(Optional.ofNullable(entity).map(Entity::m_9236_).orElse(null)).orElseThrow().m_175515_(Registries.f_268580_);
    }

    public static boolean is(DamageSource source) {
        return source.m_269150_().m_203373_(GAH_DAMAGE_RESOURCE_LOCATION);
    }

    private static final class GahDamageHolder<T>
    extends Record
    implements Holder<T> {
        private final ResourceLocation resourceLocation;
        private final T value;

        private GahDamageHolder(ResourceLocation resourceLocation, T value) {
            this.resourceLocation = resourceLocation;
            this.value = value;
        }

        public boolean m_203633_() {
            return true;
        }

        public boolean m_203373_(ResourceLocation resourceLocation) {
            return resourceLocation.equals((Object)this.resourceLocation);
        }

        public boolean m_203565_(ResourceKey<T> p_205725_) {
            return false;
        }

        public boolean m_203656_(TagKey<T> key) {
            return Sets.newHashSet((Object[])new TagKey[]{DamageTypeTags.f_268490_, DamageTypeTags.f_268437_, DamageTypeTags.f_268413_, DamageTypeTags.f_273918_, DamageTypeTags.f_276146_}).contains(key);
        }

        public boolean m_203425_(Predicate<ResourceKey<T>> p_205723_) {
            return false;
        }

        public Either<ResourceKey<T>, T> m_203439_() {
            return Either.right(this.value);
        }

        public Optional<ResourceKey<T>> m_203543_() {
            return Optional.empty();
        }

        public Holder.Kind m_203376_() {
            return Holder.Kind.DIRECT;
        }

        @Override
        public String toString() {
            return "Direct{" + String.valueOf(this.value) + "}";
        }

        public boolean m_203401_(HolderOwner<T> p_256328_) {
            return true;
        }

        public Stream<TagKey<T>> m_203616_() {
            return Stream.of(new TagKey[0]);
        }

        public T m_203334_() {
            return this.value;
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GahDamageHolder.class, "resourceLocation;value", "resourceLocation", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GahDamageHolder.class, "resourceLocation;value", "resourceLocation", "value"}, this, o);
        }

        public ResourceLocation resourceLocation() {
            return this.resourceLocation;
        }
    }
}

