/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.combat;

import com.dee12452.gahoodrpg.common.combat.GahAttribute;
import com.dee12452.gahoodrpg.common.items.curios.GahTrinketItem;
import com.dee12452.gahoodrpg.utils.ItemUtils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public record GahStats(float strength, float intelligence, float toughness, float toughnessPercent, float aegis, float aegisPercent, float dexterity, float alacrity, float vitality) {
    public static final GahStats EMPTY = GahStats.all(0.0f);

    public static GahStats all(float amount) {
        return new GahStats(amount, amount, amount, amount, amount, amount, amount, amount, amount);
    }

    public static GahStats of(Entity entity) {
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            return GahStats.projectile(projectile);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return GahStats.player(player);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return GahStats.mob(mob);
        }
        return EMPTY;
    }

    public static GahStats mob(Mob mob) {
        return new GahStats((float)(mob.m_21051_((Attribute)GahAttribute.STRENGTH.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.STRENGTH.get())), (float)(mob.m_21051_((Attribute)GahAttribute.INTELLIGENCE.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.INTELLIGENCE.get())), (float)(mob.m_21051_((Attribute)GahAttribute.TOUGHNESS.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.TOUGHNESS.get())), (float)(mob.m_21051_((Attribute)GahAttribute.TOUGHNESS_PERCENT.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.TOUGHNESS_PERCENT.get())), (float)(mob.m_21051_((Attribute)GahAttribute.AEGIS.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.AEGIS.get())), (float)(mob.m_21051_((Attribute)GahAttribute.AEGIS_PERCENT.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.AEGIS_PERCENT.get())), (float)(mob.m_21051_((Attribute)GahAttribute.DEXTERITY.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.DEXTERITY.get())), (float)(mob.m_21051_((Attribute)GahAttribute.ALACRITY.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.ALACRITY.get())), (float)(mob.m_21051_((Attribute)GahAttribute.VITALITY.get()) == null ? 0.0 : mob.m_21133_((Attribute)GahAttribute.VITALITY.get())));
    }

    public static GahStats projectile(Projectile projectile) {
        Entity entity = projectile.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return GahStats.player(player);
        }
        entity = projectile.m_19749_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return GahStats.mob(mob);
        }
        return EMPTY;
    }

    public static GahStats player(Player player) {
        return GahStats.extractGearStats((LivingEntity)player);
    }

    public static GahStats spell(Player player, float strengthDamage, float powerCoefficient, float intelligenceDamage, float magicCoefficient) {
        GahStats playerStats = GahStats.player(player);
        return new Builder().damage(strengthDamage + playerStats.strength() * powerCoefficient, intelligenceDamage + playerStats.intelligence() * magicCoefficient).build();
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    public GahStats plus(GahStats other) {
        return new GahStats(this.strength + other.strength, this.intelligence + other.intelligence, this.toughness + other.toughness, this.toughnessPercent + other.toughnessPercent, this.aegis + other.aegis, this.aegisPercent + other.aegisPercent, this.dexterity + other.dexterity, this.alacrity + other.alacrity, this.vitality + other.vitality);
    }

    public GahStats minus(GahStats other) {
        return this.plus(new GahStats(-other.strength, -other.intelligence, -other.toughness, -other.toughnessPercent, -other.aegis, -other.aegisPercent, -other.dexterity, -other.alacrity, -other.vitality));
    }

    public GahStats multiply(float multiplier) {
        return new GahStats(this.strength * multiplier, this.intelligence * multiplier, this.toughness * multiplier, this.toughnessPercent * multiplier, this.aegis * multiplier, this.aegisPercent * multiplier, this.dexterity * multiplier, this.alacrity * multiplier, this.vitality * multiplier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GahStats gahStats = (GahStats)o;
        return Float.compare(gahStats.strength, this.strength) == 0 && Float.compare(gahStats.intelligence, this.intelligence) == 0 && Float.compare(gahStats.toughness, this.toughness) == 0 && Float.compare(gahStats.toughnessPercent, this.toughnessPercent) == 0 && Float.compare(gahStats.aegis, this.aegis) == 0 && Float.compare(gahStats.aegisPercent, this.aegisPercent) == 0 && Float.compare(gahStats.dexterity, this.dexterity) == 0 && Float.compare(gahStats.alacrity, this.alacrity) == 0 && Float.compare(gahStats.vitality, this.vitality) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Float.valueOf(this.strength), Float.valueOf(this.intelligence), Float.valueOf(this.toughness), Float.valueOf(this.toughnessPercent), Float.valueOf(this.aegis), Float.valueOf(this.aegisPercent), Float.valueOf(this.dexterity), Float.valueOf(this.alacrity), Float.valueOf(this.vitality));
    }

    private static GahStats extractGearStats(LivingEntity entity) {
        GahStats stats = EMPTY;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item = entity.m_6844_(slot);
            stats = stats.plus(ItemUtils.extractItemStats(item, slot));
        }
        Optional equippedCurios = CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios);
        if (equippedCurios.isEmpty()) {
            return stats;
        }
        IItemHandlerModifiable curios = (IItemHandlerModifiable)equippedCurios.get();
        for (int slotIdx = 0; slotIdx < curios.getSlots(); ++slotIdx) {
            ItemStack item = curios.getStackInSlot(slotIdx);
            Item item2 = item.m_41720_();
            if (!(item2 instanceof GahTrinketItem)) continue;
            GahTrinketItem trinket = (GahTrinketItem)item2;
            stats = stats.plus(trinket.getStats().plus(trinket.extractAdditionalStats(item)));
        }
        return stats;
    }

    public static class Builder {
        float strength = 0.0f;
        float intelligence = 0.0f;
        float toughness = 0.0f;
        float toughnessPercent = 0.0f;
        float aegis = 0.0f;
        float aegisPercent = 0.0f;
        float dexterity = 0.0f;
        float alacrity = 0.0f;
        float vitality = 0.0f;

        public Builder() {
        }

        public Builder(GahStats initial) {
            this.strength = initial.strength();
            this.intelligence = initial.intelligence();
            this.toughness = initial.toughness();
            this.toughnessPercent = initial.toughnessPercent();
            this.aegis = initial.aegis();
            this.aegisPercent = initial.aegisPercent();
            this.dexterity = initial.dexterity();
            this.alacrity = initial.alacrity();
            this.vitality = initial.vitality();
        }

        public Builder strength(float amount) {
            this.strength = amount;
            return this;
        }

        public Builder intelligence(float amount) {
            this.intelligence = amount;
            return this;
        }

        public Builder damage(float amount) {
            return this.damage(amount, amount);
        }

        public Builder damage(float power, float magic) {
            return this.strength(power).intelligence(magic);
        }

        public Builder toughness(float amount) {
            this.toughness = amount;
            return this;
        }

        public Builder aegis(float amount) {
            this.aegis = amount;
            return this;
        }

        public Builder resist(float amount) {
            return this.resist(amount, amount);
        }

        public Builder resist(float power, float magic) {
            return this.toughness(power).aegis(magic);
        }

        public Builder toughnessPercent(float amount) {
            this.toughnessPercent = amount;
            return this;
        }

        public Builder aegisPercent(float amount) {
            this.aegisPercent = amount;
            return this;
        }

        public Builder resistPercent(float amount) {
            return this.resistPercent(amount, amount);
        }

        public Builder resistPercent(float power, float magic) {
            return this.toughnessPercent(power).aegisPercent(magic);
        }

        public Builder dexterity(float amount) {
            this.dexterity = amount;
            return this;
        }

        public Builder alacrity(float amount) {
            this.alacrity = amount;
            return this;
        }

        public Builder vitality(float amount) {
            this.vitality = amount;
            return this;
        }

        public GahStats build() {
            return new GahStats(this.strength, this.intelligence, this.toughness, this.toughnessPercent, this.aegis, this.aegisPercent, this.dexterity, this.alacrity, this.vitality);
        }
    }
}

