/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.combat.dps;

import com.dee12452.gahoodrpg.common.combat.dps.DpsEvent;
import com.dee12452.gahoodrpg.utils.TimeUtils;

public class DpsMeter {
    private static final int TICKS_TILL_DAMAGE_RESET = TimeUtils.secondsToTicks(30.0f);
    private int ticks;
    private int startTick;
    private int lastTick;
    private float currentDamage;
    private float max;

    public DpsMeter() {
        this.reset();
        this.max = 0.0f;
    }

    public void addEvent(DpsEvent event) {
        if (this.startTick <= 0) {
            this.startTick = event.tick();
        }
        this.lastTick = event.tick();
        this.currentDamage += event.damage();
        this.ticks = 0;
    }

    public float calculate() {
        if (this.currentDamage == 0.0f) {
            return 0.0f;
        }
        float elapsedSeconds = TimeUtils.ticksToSeconds(Math.max(1, this.lastTick - this.startTick + this.ticks));
        float dps = this.currentDamage / (float)((int)(1.0f + elapsedSeconds));
        this.max = Math.max(dps, this.max);
        return dps;
    }

    public void tick() {
        ++this.ticks;
        if (this.ticks > TICKS_TILL_DAMAGE_RESET || this.calculate() <= 0.0f) {
            this.reset();
        }
    }

    public float getMax() {
        return this.max;
    }

    private void reset() {
        this.ticks = 0;
        this.startTick = 0;
        this.lastTick = 0;
        this.currentDamage = 0.0f;
    }
}

