/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.data;

import com.dee12452.gahoodrpg.common.combat.GahStats;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class Cooldown
implements INBTSerializable<CompoundTag> {
    private long tickDelay;
    private long start;
    private long end;
    private boolean infinite;
    private boolean override;
    private boolean ignoreAlacrity;

    public Cooldown(long tickDelay) {
        this.tickDelay = tickDelay;
        this.start = 0L;
        this.end = 0L;
        this.infinite = tickDelay < 0L;
        this.override = false;
        this.ignoreAlacrity = false;
    }

    public Cooldown() {
        this(0L);
    }

    public long getTickDelay() {
        return this.tickDelay;
    }

    public void setTickDelay(long tickDelay) {
        this.tickDelay = tickDelay;
        if (tickDelay > 0L) {
            this.infinite = false;
        }
    }

    public Cooldown setIgnoreAlacrity() {
        this.ignoreAlacrity = true;
        return this;
    }

    public float getCooldownPercent(LivingEntity user) {
        Level level = user.m_9236_();
        this.end = level.m_46467_();
        long diff = this.end - this.start;
        long goal = this.tickDelay;
        if (diff >= goal || (float)goal == 0.0f) {
            return 1.0f;
        }
        return (float)diff / (float)goal;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("delay", this.tickDelay);
        tag.m_128356_("start", this.start);
        tag.m_128356_("end", this.end);
        tag.m_128379_("override", this.override);
        tag.m_128379_("ignoreAlacrity", this.ignoreAlacrity);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.tickDelay = nbt.m_128454_("delay");
        this.start = nbt.m_128454_("start");
        this.end = nbt.m_128454_("end");
        this.override = nbt.m_128471_("override");
        this.ignoreAlacrity = nbt.m_128471_("ignoreAlacrity");
    }

    public boolean checkAndReset(LivingEntity user) {
        if (!this.infinite && this.check(user)) {
            this.reset(user);
            return true;
        }
        return false;
    }

    public boolean checkAndReset(Level level) {
        if (!this.infinite && this.check(level)) {
            this.reset(level);
            return true;
        }
        return false;
    }

    public boolean check(LivingEntity user) {
        this.end = user.m_9236_().m_46467_();
        long diff = this.end - this.start;
        return this.override || !this.infinite && (this.start > this.end || diff >= this.getAlacrityDelay(user));
    }

    public boolean check(Level level) {
        this.end = level.m_46467_();
        long diff = this.end - this.start;
        return this.override || !this.infinite && (this.start > this.end || diff >= this.tickDelay);
    }

    public void reset(LivingEntity user) {
        this.reset(user.m_9236_());
    }

    public void reset(Level level) {
        this.end = this.start = level.m_46467_();
        this.override = false;
    }

    public void setOverride() {
        this.override = true;
    }

    public void forceReady(LivingEntity entity) {
        this.check(entity);
        this.start = this.end - this.tickDelay;
    }

    public void forceReady(Level level) {
        this.check(level);
        this.start = this.end - this.tickDelay;
    }

    private long getAlacrityDelay(LivingEntity entity) {
        if (this.ignoreAlacrity) {
            return this.tickDelay;
        }
        long alacrity = (long)GahStats.of((Entity)entity).alacrity();
        if (alacrity <= 0L) {
            return this.tickDelay;
        }
        return Math.max(this.tickDelay / 10L, this.tickDelay - alacrity);
    }
}

