/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.data;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.utils.ItemUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.util.INBTSerializable;

public class EquipmentCache
implements INBTSerializable<CompoundTag> {
    private ItemStack helmetItem;
    private ItemStack chestItem;
    private ItemStack legsItem;
    private ItemStack bootsItem;
    private ItemStack mainHandItem;
    private ItemStack offHandItem;
    private boolean isCached;

    public EquipmentCache() {
        this.clear();
    }

    public void save(ServerPlayer player) {
        if (this.isCached) {
            return;
        }
        this.helmetItem = this.extractItem(player, EquipmentSlot.HEAD);
        this.chestItem = this.extractItem(player, EquipmentSlot.CHEST);
        this.legsItem = this.extractItem(player, EquipmentSlot.LEGS);
        this.bootsItem = this.extractItem(player, EquipmentSlot.FEET);
        this.mainHandItem = this.extractItem(player, InteractionHand.MAIN_HAND);
        this.offHandItem = this.extractItem(player, InteractionHand.OFF_HAND);
        CommonPlayerCapability caps = Capabilities.commonPlayer((Player)player);
        Item mainHandItem = ItemUtils.fromId(caps.getMainHandSwapItemId());
        Item offHandItem = ItemUtils.fromId(caps.getOffHandSwapItemId());
        for (int slotIdx = 0; slotIdx < player.m_150109_().f_35974_.size(); ++slotIdx) {
            ItemStack item = (ItemStack)player.m_150109_().f_35974_.get(slotIdx);
            if (!Items.f_41852_.equals(mainHandItem) && item.m_150930_(mainHandItem)) {
                this.mainHandItem = this.extractItem(player, slotIdx);
            }
            if (Items.f_41852_.equals(offHandItem) || !item.m_150930_(offHandItem)) continue;
            this.offHandItem = this.extractItem(player, slotIdx);
        }
        this.isCached = true;
    }

    public void load(ServerPlayer player) {
        player.m_8061_(EquipmentSlot.HEAD, this.helmetItem);
        player.m_8061_(EquipmentSlot.CHEST, this.chestItem);
        player.m_8061_(EquipmentSlot.LEGS, this.legsItem);
        player.m_8061_(EquipmentSlot.FEET, this.bootsItem);
        player.m_8061_(EquipmentSlot.MAINHAND, this.mainHandItem);
        player.m_8061_(EquipmentSlot.OFFHAND, this.offHandItem);
        this.clear();
    }

    public void clear() {
        this.helmetItem = ItemStack.f_41583_;
        this.chestItem = ItemStack.f_41583_;
        this.legsItem = ItemStack.f_41583_;
        this.bootsItem = ItemStack.f_41583_;
        this.mainHandItem = ItemStack.f_41583_;
        this.offHandItem = ItemStack.f_41583_;
        this.isCached = false;
    }

    private ItemStack extractItem(ServerPlayer player, EquipmentSlot slot) {
        ItemStack value = player.m_6844_(slot);
        player.m_8061_(slot, ItemStack.f_41583_);
        return value;
    }

    private ItemStack extractItem(ServerPlayer player, InteractionHand hand) {
        ItemStack value = player.m_21120_(hand);
        player.m_21008_(hand, ItemStack.f_41583_);
        return value;
    }

    private ItemStack extractItem(ServerPlayer player, int itemSlotIdx) {
        ItemStack value = (ItemStack)player.m_150109_().f_35974_.get(itemSlotIdx);
        player.m_150109_().f_35974_.set(itemSlotIdx, (Object)ItemStack.f_41583_);
        return value;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("helmetItem", (Tag)this.helmetItem.serializeNBT());
        nbt.m_128365_("chestItem", (Tag)this.chestItem.serializeNBT());
        nbt.m_128365_("legsItem", (Tag)this.legsItem.serializeNBT());
        nbt.m_128365_("bootsItem", (Tag)this.bootsItem.serializeNBT());
        nbt.m_128365_("mainHandItem", (Tag)this.mainHandItem.serializeNBT());
        nbt.m_128365_("offHandItem", (Tag)this.offHandItem.serializeNBT());
        nbt.m_128379_("isCached", this.isCached);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.helmetItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("helmetItem"));
        this.chestItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("chestItem"));
        this.legsItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("legsItem"));
        this.bootsItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("bootsItem"));
        this.mainHandItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("mainHandItem"));
        this.offHandItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("offHandItem"));
        this.isCached = nbt.m_128471_("isCached");
    }
}

