/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.data;

import com.dee12452.gahoodrpg.common.data.RaidTracker;
import com.dee12452.gahoodrpg.common.data.SentinelTracker;
import com.dee12452.gahoodrpg.common.entities.living.boss.Chieftainer;
import com.dee12452.gahoodrpg.common.entities.living.boss.Sentinel;
import com.dee12452.gahoodrpg.common.entities.living.boss.TheEnraged;
import com.dee12452.gahoodrpg.common.entities.living.boss.ThePharaoh;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.TheDruid;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class GahWorldSavedData
extends SavedData {
    private boolean enderDragonSlain;
    private boolean theEnragedSlain;
    private boolean thePharaohSlain;
    private boolean theDruidSlain;
    private boolean chieftainerSlain;
    private boolean sentinelSlain;
    private boolean wardenSlain;
    private final RaidTracker raidTracker;
    private final SentinelTracker sentinelTracker;

    private GahWorldSavedData(CompoundTag nbt) {
        this.enderDragonSlain = NbtUtils.getIfPresent(nbt, "enderDragonSlain", CompoundTag::m_128471_).orElse(false);
        this.theEnragedSlain = NbtUtils.getIfPresent(nbt, "theEnragedSlain", CompoundTag::m_128471_).orElse(false);
        this.thePharaohSlain = NbtUtils.getIfPresent(nbt, "thePharaohSlain", CompoundTag::m_128471_).orElse(false);
        this.theDruidSlain = NbtUtils.getIfPresent(nbt, "theDruidSlain", CompoundTag::m_128471_).orElse(false);
        this.chieftainerSlain = NbtUtils.getIfPresent(nbt, "chieftainerSlain", CompoundTag::m_128471_).orElse(false);
        this.sentinelSlain = NbtUtils.getIfPresent(nbt, "sentinelSlain", CompoundTag::m_128471_).orElse(false);
        this.wardenSlain = NbtUtils.getIfPresent(nbt, "wardenSlain", CompoundTag::m_128471_).orElse(false);
        this.raidTracker = (RaidTracker)NbtUtils.getIfPresent(nbt, "raidTracker", RaidTracker::new).orElse(new RaidTracker());
        this.sentinelTracker = (SentinelTracker)NbtUtils.getIfPresent(nbt, "sentinelTracker", SentinelTracker::new).orElse(new SentinelTracker());
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
        nbt.m_128379_("enderDragonSlain", this.enderDragonSlain);
        nbt.m_128379_("theEnragedSlain", this.theEnragedSlain);
        nbt.m_128379_("thePharaohSlain", this.thePharaohSlain);
        nbt.m_128379_("theDruidSlain", this.theDruidSlain);
        nbt.m_128379_("chieftainerSlain", this.chieftainerSlain);
        nbt.m_128379_("sentinelSlain", this.sentinelSlain);
        nbt.m_128379_("wardenSlain", this.wardenSlain);
        nbt.m_128365_("raidTracker", (Tag)this.raidTracker.serializeNBT());
        nbt.m_128365_("sentinelTracker", (Tag)this.sentinelTracker.serializeNBT());
        return nbt;
    }

    public boolean isEnderDragonSlain() {
        return this.enderDragonSlain;
    }

    public boolean isTheEnragedSlain() {
        return this.theEnragedSlain;
    }

    public boolean isThePharaohSlain() {
        return this.thePharaohSlain;
    }

    public boolean isTheDruidSlain() {
        return this.theDruidSlain;
    }

    public boolean isChieftainerSlain() {
        return this.chieftainerSlain;
    }

    public boolean isSentinelSlain() {
        return this.sentinelSlain;
    }

    public boolean isWardenSlain() {
        return this.wardenSlain;
    }

    public RaidTracker getRaidTracker() {
        return this.raidTracker;
    }

    public SentinelTracker getSentinelTracker() {
        return this.sentinelTracker;
    }

    public void onLivingDeath(LivingEntity livingEntity) {
        if (livingEntity instanceof TheEnraged) {
            this.theEnragedSlain = true;
            this.m_77762_();
        } else if (livingEntity instanceof ThePharaoh) {
            this.thePharaohSlain = true;
            this.m_77762_();
        } else if (livingEntity instanceof TheDruid) {
            this.theDruidSlain = true;
            this.m_77762_();
        } else if (livingEntity instanceof EnderDragon) {
            this.enderDragonSlain = true;
            this.m_77762_();
        } else if (livingEntity instanceof Chieftainer) {
            this.chieftainerSlain = true;
            this.m_77762_();
        } else if (livingEntity instanceof Sentinel) {
            this.sentinelSlain = true;
            this.m_77762_();
        } else if (livingEntity instanceof ElderGuardian) {
            ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
            this.sentinelTracker.onElderGuardianKill(elderGuardian);
            this.m_77762_();
        } else if (livingEntity instanceof Warden) {
            this.wardenSlain = true;
            this.m_77762_();
        }
    }

    public static GahWorldSavedData load(MinecraftServer server) {
        ServerLevel level = WorldUtils.getOverworldLevel(server).orElseThrow();
        return (GahWorldSavedData)level.m_8895_().m_164861_(GahWorldSavedData::new, () -> new GahWorldSavedData(new CompoundTag()), "gahWorldSavedData");
    }
}

