/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.data;

import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotResult;

public class GraveboxData
implements INBTSerializable<CompoundTag> {
    @Nullable
    private BlockPos boxPos = null;
    private final LinkedList<List<ItemStack>> cache = new LinkedList();

    @Nullable
    public BlockPos getBoxPos() {
        return this.boxPos;
    }

    public void setBoxPos(@Nullable BlockPos boxPos) {
        this.boxPos = boxPos;
    }

    public boolean addToCache(Player player) {
        List<ItemStack> items = this.getAllPlayerItems(player, ItemStack::m_41777_);
        if (items.isEmpty()) {
            return true;
        }
        if (this.cache.size() > 5) {
            return false;
        }
        player.m_150109_().m_6211_();
        EntityUtils.removeCurios((LivingEntity)player);
        this.cache.offer(items);
        return true;
    }

    public PopResult popCache(Player player) {
        if (this.cache.isEmpty()) {
            return PopResult.EMPTY;
        }
        List<ItemStack> latestCache = this.cache.peek();
        List<ItemStack> playerItems = player.m_150109_().f_35974_.stream().filter(item -> !item.m_41619_()).toList();
        if (latestCache.size() + playerItems.size() >= player.m_150109_().f_35974_.size()) {
            return PopResult.FULL_INVENTORY;
        }
        List<ItemStack> cacheToAdd = this.cache.poll();
        if (cacheToAdd == null) {
            return PopResult.EMPTY;
        }
        for (ItemStack item2 : cacheToAdd) {
            player.m_150109_().m_36054_(item2);
        }
        return PopResult.SUCCESS;
    }

    public int getCacheSize() {
        return this.cache.size();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.boxPos != null) {
            NbtUtils.writeBlockPos(nbt, "boxPos", this.boxPos);
        }
        nbt.m_128405_("cacheSize", this.cache.size());
        for (int idx = 0; idx < this.cache.size(); ++idx) {
            NbtUtils.writeList(nbt, "cache" + idx, this.cache.get(idx), (tag, name, item) -> tag.m_128365_(name, (Tag)item.serializeNBT()));
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (NbtUtils.hasBlockPos(nbt, "boxPos")) {
            this.boxPos = NbtUtils.readBlockPos(nbt, "boxPos");
        }
        this.cache.clear();
        int size = nbt.m_128451_("cacheSize");
        for (int idx = 0; idx < size; ++idx) {
            List<ItemStack> itemList = NbtUtils.readList(nbt, "cache" + idx, (tag, name) -> ItemStack.m_41712_((CompoundTag)tag.m_128469_(name)));
            this.cache.add(itemList);
        }
    }

    private List<ItemStack> getAllPlayerItems(Player player, Function<ItemStack, ItemStack> converter) {
        ArrayList<ItemStack> newCache = new ArrayList<ItemStack>();
        Inventory inventory = player.m_150109_();
        List<ItemStack> curiosItems = EntityUtils.getCuriosSlots((LivingEntity)player).stream().map(SlotResult::stack).toList();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(curiosItems);
        items.addAll((Collection<ItemStack>)inventory.f_35974_);
        items.addAll((Collection<ItemStack>)inventory.f_35975_);
        items.addAll((Collection<ItemStack>)inventory.f_35976_);
        for (ItemStack item : items) {
            if (item.m_41619_()) continue;
            newCache.add(converter.apply(item));
        }
        return newCache;
    }

    public static enum PopResult {
        SUCCESS,
        EMPTY,
        FULL_INVENTORY;

    }
}

