/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.data;

import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.raid.Raid;
import net.minecraftforge.common.util.INBTSerializable;

public class RaidTracker
implements INBTSerializable<CompoundTag> {
    private static final int VERSION = 1;
    private final Map<Integer, RaidStatus> raidStatusMap = new HashMap<Integer, RaidStatus>();

    public boolean tick(ServerLevel level) {
        Optional<Raid> nextRaid = this.findNextRaid(level);
        nextRaid.ifPresent(raid -> this.raidStatusMap.put(raid.m_37781_(), RaidStatus.IN_PROGRESS));
        this.tickRaidStatuses(level);
        return nextRaid.isPresent();
    }

    public Optional<BlockPos> findSuccessfulRaidPosition(ServerLevel level) {
        Optional<Map.Entry> successfulRaid = this.raidStatusMap.entrySet().stream().filter(r -> r.getValue() == RaidStatus.SUCCESS).findFirst();
        if (successfulRaid.isPresent()) {
            this.raidStatusMap.put((Integer)successfulRaid.get().getKey(), RaidStatus.MARKED);
            return Optional.of(level.m_8905_().m_37958_(((Integer)successfulRaid.get().getKey()).intValue()).m_37780_());
        }
        return Optional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        NbtUtils.writeMap(nbt, "raidStatusMap", this.raidStatusMap, Object::toString, (tag, name, item) -> tag.m_128405_(name, item.ordinal()));
        nbt.m_128405_("version", 1);
        return nbt;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.raidStatusMap.clear();
        int version = NbtUtils.getIfPresent(compoundTag, "version", CompoundTag::m_128451_).orElse(-1);
        if (version == 1) {
            this.raidStatusMap.putAll(NbtUtils.readMap(compoundTag, "raidStatusMap", Integer::parseInt, (tag, name) -> RaidStatus.values()[tag.m_128451_(name)]));
        }
    }

    private Optional<Raid> findNextRaid(ServerLevel level) {
        MinecraftServer server = level.m_7654_();
        if (server.m_129921_() % 20 != 0) {
            return Optional.empty();
        }
        Raid raid = null;
        for (ServerPlayer player : EntityUtils.getTargetablePlayers(level)) {
            raid = level.m_8905_().m_37970_(player.m_20183_(), 10);
            if (raid == null) continue;
            break;
        }
        if (raid == null || this.raidStatusMap.containsKey(raid.m_37781_())) {
            return Optional.empty();
        }
        return Optional.of(raid);
    }

    private void tickRaidStatuses(ServerLevel level) {
        if (level.m_7654_().m_129921_() % 10 != 0) {
            return;
        }
        for (int key : this.raidStatusMap.keySet()) {
            Raid raid;
            if (this.raidStatusMap.get(key) != RaidStatus.IN_PROGRESS || (raid = level.m_8905_().m_37958_(key)) == null) continue;
            if (raid.m_37767_()) {
                this.raidStatusMap.put(key, RaidStatus.SUCCESS);
                continue;
            }
            if (!raid.m_37768_() && !raid.m_37762_()) continue;
            this.raidStatusMap.put(key, RaidStatus.MARKED);
        }
    }

    private static enum RaidStatus {
        IN_PROGRESS,
        SUCCESS,
        MARKED;

    }
}

