/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.data;

import com.dee12452.gahoodrpg.common.entities.living.boss.Sentinel;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;

public class SentinelTracker
implements INBTSerializable<CompoundTag> {
    private int elderGuardiansKilled = 0;

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("elderGuardiansKilled", this.elderGuardiansKilled);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.elderGuardiansKilled = nbt.m_128451_("elderGuardiansKilled");
    }

    public void onElderGuardianKill(ElderGuardian elderGuardian) {
        block4: {
            List<ServerPlayer> nearbyPlayers;
            block3: {
                ++this.elderGuardiansKilled;
                nearbyPlayers = EntityUtils.getTargetablePlayers((ServerLevel)elderGuardian.m_9236_(), elderGuardian.m_20191_().m_82400_(20.0));
                if (this.elderGuardiansKilled % 3 != 0) break block3;
                Optional<BlockPos> spawnPos = this.findSentinelSpawnPosition(elderGuardian);
                if (spawnPos.isEmpty()) {
                    return;
                }
                Sentinel sentinel = (Sentinel)((EntityType)LivingEntityRegistry.SENTINEL.get()).m_262496_((ServerLevel)elderGuardian.m_9236_(), spawnPos.get(), MobSpawnType.MOB_SUMMONED);
                if (sentinel == null) break block4;
                for (ServerPlayer player : nearbyPlayers) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.boss.sentinel.spawn"), true);
                }
                break block4;
            }
            for (ServerPlayer player : nearbyPlayers) {
                player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.boss.sentinel.watch"), true);
            }
        }
    }

    private Optional<BlockPos> findSentinelSpawnPosition(ElderGuardian elderGuardian) {
        ServerLevel level = (ServerLevel)elderGuardian.m_9236_();
        BlockPos pos = elderGuardian.m_20183_();
        int timesChecked = 0;
        boolean valid = false;
        while (timesChecked < 64) {
            AABB boxToCheck = new AABB(pos).m_82400_(3.0);
            Stream blockStates = level.m_45556_(boxToCheck);
            if (blockStates.allMatch(s -> s.m_60795_() || s.m_60819_().m_192917_((Fluid)Fluids.f_76193_))) {
                valid = true;
                break;
            }
            ++timesChecked;
            pos = pos.m_7494_();
        }
        if (!valid) {
            return Optional.empty();
        }
        return Optional.of(pos);
    }
}

