/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block;

import com.dee12452.gahoodrpg.common.entities.block.GahSlotBlockEntityBase;
import com.dee12452.gahoodrpg.common.entities.living.IGahMob;
import com.dee12452.gahoodrpg.common.menus.BossSpawnTableMenu;
import com.dee12452.gahoodrpg.common.registries.BlockEntityRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossSpawnTableEntity
extends GahSlotBlockEntityBase {
    public BossSpawnTableEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BOSS_SPAWN_TABLE_BLOCK_ENTITY.get(), blockPos, blockState, 4);
    }

    public int @NotNull [] m_7071_(@NotNull Direction p_19238_) {
        return new int[0];
    }

    public boolean m_7155_(int p_19235_, @NotNull ItemStack p_19236_, @Nullable Direction p_19237_) {
        return false;
    }

    public boolean m_7157_(int p_19239_, @NotNull ItemStack p_19240_, @NotNull Direction p_19241_) {
        return false;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"menu.gahoodrpg.boss_spawn_table.name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new BossSpawnTableMenu(id, inventory, (Container)this, player, boss -> this.checkBossSpawn((EntityType<?>)boss, player), this.m_58899_());
    }

    private boolean checkBossSpawn(EntityType<?> boss, Player player) {
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean bossExists = false;
        for (Entity entity : serverLevel.m_8583_()) {
            IGahMob gahMob;
            if (!(entity instanceof IGahMob) || !(gahMob = (IGahMob)entity).isBoss()) continue;
            bossExists = true;
            break;
        }
        if (bossExists) {
            return false;
        }
        Optional<?> newBoss = this.spawnBoss(boss, level);
        return newBoss.isPresent();
    }

    private <T extends Entity> Optional<T> spawnBoss(EntityType<T> boss, Level level) {
        Entity newBoss = boss.m_20615_(level);
        if (newBoss == null) {
            return Optional.empty();
        }
        BlockPos newBossBlockPos = this.m_58899_().m_7494_();
        Vec3 newBossPos = newBossBlockPos.m_252807_();
        newBoss.m_146884_(newBossPos);
        level.m_7967_(newBoss);
        return Optional.of(newBoss);
    }
}

