/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block;

import com.dee12452.gahoodrpg.common.entities.block.GahSlotBlockEntityBase;
import com.dee12452.gahoodrpg.common.entities.block.ITickingBlockEntity;
import com.dee12452.gahoodrpg.common.menus.ForgingStationMenu;
import com.dee12452.gahoodrpg.common.recipes.ForgingStationRecipe;
import com.dee12452.gahoodrpg.common.recipes.GenericCraftingContainer;
import com.dee12452.gahoodrpg.common.registries.BlockEntityRegistry;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgingStationBlockEntity
extends GahSlotBlockEntityBase
implements ContainerData,
ITickingBlockEntity {
    private static final float DEFAULT_COOK_TIME_SECS = 5.0f;
    private static final float DEFAULT_FUEL_NEEDS_PER_COOK = 2.5f;
    @Nullable
    private ItemStack nextCookingItem;
    @Nullable
    private ItemStack currentCookingItem;
    private int fuelTicksRemaining = 0;
    private int totalFuelTicks = 0;
    private int currentCookTicks = 0;
    private int totalCookTicks = TimeUtils.secondsToTicks(5.0f);
    private boolean lit = false;

    public ForgingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.FORGING_STATION_BLOCK_ENTITY.get(), blockPos, blockState, 6);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.currentCookTicks >= this.totalCookTicks) {
            this.onCookComplete(level, pos, state);
            return;
        }
        if (this.currentCookingItem == null) {
            if (this.nextCookingItem != null) {
                this.currentCookingItem = this.nextCookingItem;
                this.nextCookingItem = null;
            } else {
                return;
            }
        }
        if (this.fuelTicksRemaining <= 0 && !this.eatFuel()) {
            this.stopCooking(level, pos, state);
            return;
        }
        if (!this.lit) {
            this.startCooking(level, pos, state);
        }
        ++this.currentCookTicks;
        --this.fuelTicksRemaining;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"menu.gahoodrpg.forging_station.name");
    }

    public int @NotNull [] m_7071_(@NotNull Direction p_19238_) {
        return new int[0];
    }

    public boolean m_7155_(int p_19235_, @NotNull ItemStack p_19236_, @Nullable Direction p_19237_) {
        return false;
    }

    public boolean m_7157_(int p_19239_, @NotNull ItemStack p_19240_, @NotNull Direction p_19241_) {
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory inventory, final @NotNull Player player) {
        ForgingStationMenu menu = new ForgingStationMenu(containerId, inventory, (Container)this, this);
        menu.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu menu, int i, @NotNull ItemStack itemStack) {
                ForgingStationBlockEntity.this.updateRecipe(player.m_9236_());
            }

            public void m_142153_(@NotNull AbstractContainerMenu menu, int i, int i1) {
                ForgingStationBlockEntity.this.updateRecipe(player.m_9236_());
            }
        });
        return menu;
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        NbtUtils.putIfPresent(tag, "currentCookingItem", this.currentCookingItem, (t, s, i) -> t.m_128365_(s, (Tag)i.m_41739_(new CompoundTag())));
        NbtUtils.putIfPresent(tag, "nextCookingItem", this.nextCookingItem, (t, s, i) -> t.m_128365_(s, (Tag)i.m_41739_(new CompoundTag())));
        tag.m_128379_("lit", this.lit);
        tag.m_128405_("fuelTicksRemaining", this.fuelTicksRemaining);
        tag.m_128405_("totalFuelTicks", this.totalFuelTicks);
        tag.m_128405_("currentCookTicks", this.currentCookTicks);
        tag.m_128405_("totalCookTicks", this.totalCookTicks);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.currentCookingItem = NbtUtils.getIfPresent(tag, "currentCookingItem", (t, s) -> ItemStack.m_41712_((CompoundTag)t.m_128469_(s))).orElse(null);
        this.nextCookingItem = NbtUtils.getIfPresent(tag, "nextCookingItem", (t, s) -> ItemStack.m_41712_((CompoundTag)t.m_128469_(s))).orElse(null);
        this.lit = tag.m_128471_("lit");
        this.fuelTicksRemaining = tag.m_128451_("fuelTicksRemaining");
        this.totalFuelTicks = tag.m_128451_("totalFuelTicks");
        this.currentCookTicks = tag.m_128451_("currentCookTicks");
        this.totalCookTicks = tag.m_128451_("totalCookTicks");
    }

    public int m_6413_(int idx) {
        switch (idx) {
            case 0: {
                return this.lit ? 1 : 0;
            }
            case 1: {
                return this.fuelTicksRemaining;
            }
            case 2: {
                return this.totalFuelTicks;
            }
            case 3: {
                return this.currentCookTicks;
            }
            case 4: {
                return this.totalCookTicks;
            }
        }
        return -1;
    }

    public void m_8050_(int idx, int val) {
        switch (idx) {
            case 0: {
                this.lit = val == 1;
                break;
            }
            case 1: {
                this.fuelTicksRemaining = val;
                break;
            }
            case 2: {
                this.totalFuelTicks = val;
                break;
            }
            case 3: {
                this.currentCookTicks = val;
                break;
            }
            case 4: {
                this.totalCookTicks = val;
            }
        }
    }

    public int m_6499_() {
        return 5;
    }

    private void startCooking(Level level, BlockPos pos, BlockState state) {
        this.lit = true;
        this.totalCookTicks = TimeUtils.secondsToTicks(5.0f);
        this.totalFuelTicks = TimeUtils.secondsToTicks(2.0f);
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            stack.m_41764_(stack.m_41613_() - 1);
        }
        this.updateBlockState(level, pos, state);
    }

    private void stopCooking(Level level, BlockPos pos, BlockState state) {
        if (!this.lit) {
            return;
        }
        this.lit = false;
        this.updateBlockState(level, pos, state);
    }

    private boolean eatFuel() {
        if (!this.hasFuel()) {
            return false;
        }
        ItemStack fuel = this.getFuel();
        fuel.m_41764_(fuel.m_41613_() - 1);
        this.totalFuelTicks = TimeUtils.secondsToTicks(2.0f);
        this.fuelTicksRemaining = 0;
        this.fuelTicksRemaining += this.totalFuelTicks;
        return true;
    }

    private void updateBlockState(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.lit)), 3);
    }

    private boolean hasFuel() {
        return ForgingStationMenu.isFuel(this.getFuel());
    }

    private ItemStack getFuel() {
        return this.m_8020_(4);
    }

    private void onCookComplete(Level level, BlockPos pos, BlockState state) {
        boolean shouldIncrementResult;
        this.stopCooking(level, pos, state);
        if (this.currentCookingItem == null) {
            return;
        }
        ItemStack resultSlot = this.m_8020_(5);
        boolean shouldSetResult = resultSlot.m_41619_();
        boolean bl = shouldIncrementResult = !shouldSetResult && resultSlot.m_150930_(this.currentCookingItem.m_41720_()) && resultSlot.m_41613_() + this.currentCookingItem.m_41613_() < resultSlot.m_41741_();
        if (shouldSetResult) {
            this.m_6836_(5, this.currentCookingItem.m_41777_());
        } else if (shouldIncrementResult) {
            resultSlot.m_41764_(resultSlot.m_41613_() + this.currentCookingItem.m_41613_());
        }
        if (shouldSetResult || shouldIncrementResult) {
            this.currentCookTicks = 0;
            this.currentCookingItem = null;
            this.updateRecipe(level);
        }
    }

    private void updateRecipe(Level level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return;
        }
        this.nextCookingItem = null;
        RecipeManager recipeManager = server.m_129894_();
        GenericCraftingContainer craftingContainer = new GenericCraftingContainer(2, 2);
        for (int idx = 0; idx < 4; ++idx) {
            craftingContainer.m_6836_(idx, this.m_8020_(idx));
        }
        Optional recipe = recipeManager.m_44015_(ForgingStationRecipe.RECIPE_TYPE, (Container)craftingContainer, level);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack currentFuelItem = this.m_8020_(4);
        ForgingStationRecipe forgingStationRecipe = (ForgingStationRecipe)((Object)recipe.get());
        if (Arrays.stream(forgingStationRecipe.getFuelIngredient().m_43908_()).noneMatch(fuelIng -> currentFuelItem.m_150930_(fuelIng.m_41720_()))) {
            return;
        }
        this.nextCookingItem = forgingStationRecipe.m_8043_((RegistryAccess)server.m_206579_());
    }
}

