/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class GahSlotBlockEntityBase
extends BlockEntity
implements WorldlyContainer,
MenuProvider {
    protected final List<ItemStack> slots = new ArrayList<ItemStack>();

    public GahSlotBlockEntityBase(BlockEntityType<?> entityType, BlockPos blockPos, BlockState blockState, int numSlots) {
        super(entityType, blockPos, blockState);
        for (int i = 0; i < numSlots; ++i) {
            this.slots.add(ItemStack.f_41583_);
        }
    }

    public int m_6643_() {
        return this.slots.size();
    }

    public boolean m_7983_() {
        return this.slots.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.getItemAtSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int stackSize) {
        return ContainerHelper.m_18969_(this.slots, (int)slot, (int)stackSize);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.slots, (int)slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack newItem) {
        ItemStack originalItem = this.getItemAtSlot(slot);
        this.slots.set(slot, newItem);
        if (newItem.m_41613_() > this.m_6893_()) {
            newItem.m_41764_(this.m_6893_());
        }
        if (!(slot != 0 && slot != 1 || ItemStack.m_41656_((ItemStack)originalItem, (ItemStack)newItem))) {
            this.m_6596_();
        }
    }

    public void m_6211_() {
        Collections.fill(this.slots, ItemStack.f_41583_);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.loadSlots(tag);
    }

    public boolean m_6542_(@NotNull Player p_18946_) {
        return true;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        this.saveSlots(tag);
    }

    private ItemStack getItemAtSlot(int slot) {
        return slot < this.slots.size() ? this.slots.get(slot) : ItemStack.f_41583_;
    }

    private void loadSlots(CompoundTag tag) {
        ListTag listtag = tag.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= this.slots.size()) continue;
            this.slots.set(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    private void saveSlots(CompoundTag tag) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.slots.size(); ++i) {
            ItemStack itemstack = this.slots.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("Items", (Tag)listtag);
    }
}

