/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block;

import com.dee12452.gahoodrpg.common.entities.block.ITickingBlockEntity;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSetBlockOwner;
import com.dee12452.gahoodrpg.common.registries.BlockEntityRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveboxBlockEntity
extends BlockEntity
implements ITickingBlockEntity {
    private int ticks = 0;
    @Nullable
    private UUID ownerId;

    public GraveboxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.GRAVEBOX_BLOCK_ENTITY.get(), pos, state);
    }

    public void setOwner(ServerPlayer player) {
        if (this.ownerId == null) {
            this.ownerId = player.m_20148_();
        }
    }

    public void setOwnerId(UUID id) {
        if (this.ownerId == null) {
            this.ownerId = id;
        }
    }

    public boolean isOwner(Player player) {
        return Optional.ofNullable(this.ownerId).map(uuid -> uuid.equals(player.m_20148_())).orElse(false);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            return;
        }
        if (this.ticks % 20 == 0) {
            this.updateNearbyPlayers((ServerLevel)level);
        }
        ++this.ticks;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("owner")) {
            this.ownerId = nbt.m_128342_("owner");
        }
        this.ticks = nbt.m_128451_("ticks");
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        Optional.ofNullable(this.ownerId).ifPresent(uuid -> nbt.m_128362_("owner", uuid));
        nbt.m_128405_("ticks", this.ticks);
    }

    private void updateNearbyPlayers(ServerLevel serverLevel) {
        AABB aabb = new AABB(this.m_58899_()).m_82377_(10.0, 5.0, 10.0);
        ClientSetBlockOwner.Message message = new ClientSetBlockOwner.Message(this.ownerId, this.m_58899_());
        serverLevel.m_45976_(ServerPlayer.class, aabb).forEach(player -> NetworkChannel.sendToClient(player, message));
    }
}

