/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.boss;

import com.dee12452.gahoodrpg.common.blocks.Blocks;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerBlockEntity;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public class BossArenaManager {
    private final BlockPos bossSpawnerPos;
    private final ServerLevel level;

    public BossArenaManager(BossSpawnerBlockEntity blockEntity) {
        this.bossSpawnerPos = blockEntity.m_58899_();
        this.level = (ServerLevel)blockEntity.getLevelUnsafe();
    }

    public void create() {
        final BlockPos center = this.getBossPlacement().m_7495_();
        Predicate<BlockPos> distanceCheck = new Predicate<BlockPos>(){

            @Override
            public boolean test(BlockPos blockPos) {
                return Math.abs(center.m_123341_() - blockPos.m_123341_()) > 30 || Math.abs(center.m_123343_() - blockPos.m_123343_()) > 30;
            }
        };
        this.bfs(center, arg_0 -> this.lambda$create$0(distanceCheck, arg_0));
    }

    public void destroy() {
        BlockPos center = this.getBossPlacement().m_7495_();
        this.bfs(center, ctx -> {
            BlockPos next = ctx.pos();
            if (this.level.m_8055_(next).m_60795_()) {
                return false;
            }
            this.level.m_7731_(next, net.minecraft.world.level.block.Blocks.f_50016_.m_49966_(), 3);
            return true;
        });
    }

    private void bfs(BlockPos start, Function<BFSContext, Boolean> onNext) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.offer(start);
        while (!queue.isEmpty()) {
            BlockPos next = (BlockPos)queue.poll();
            if (visited.contains(next)) continue;
            visited.add(next);
            if (!onNext.apply(new BFSContext(next)).booleanValue()) {
                return;
            }
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (i == 0 && j == 0) continue;
                    queue.offer(new BlockPos(next.m_123341_() + i, next.m_123342_(), next.m_123343_() + j));
                }
            }
        }
    }

    public BlockPos getBossPlacement() {
        return this.bossSpawnerPos.m_175288_(200).m_7494_();
    }

    private /* synthetic */ Boolean lambda$create$0(1 distanceCheck, BFSContext ctx) {
        BlockPos next = ctx.pos();
        if (distanceCheck.test(next)) {
            return false;
        }
        this.level.m_7731_(next, ((Block)Blocks.BOSS_ROOM_FLOOR.get()).m_49966_(), 3);
        BlockPos above = next.m_7494_();
        for (int i = 0; i < 7; ++i) {
            if (!this.level.m_8055_(above).m_60795_()) {
                this.level.m_7731_(above, net.minecraft.world.level.block.Blocks.f_50016_.m_49966_(), 3);
            }
            above = above.m_7494_();
        }
        return true;
    }

    private record BFSContext(BlockPos pos) {
    }
}

