/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.boss;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossArenaManager;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossLootGenerator;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerState;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class BossFightGoal
extends Goal {
    private final BossSpawnerBlockEntity blockEntity;

    public BossFightGoal(BossSpawnerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public boolean m_8036_() {
        return this.blockEntity.getState() == BossSpawnerState.FIGHTING;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        ServerLevel level = (ServerLevel)this.blockEntity.getLevelUnsafe();
        if (!this.checkBoss(level)) {
            return;
        }
        if (!this.checkPlayers(level)) {
            return;
        }
    }

    private boolean checkBoss(ServerLevel level) {
        Optional<GahBossBase<?, ?>> boss = this.blockEntity.findBoss();
        if (boss.isEmpty()) {
            this.finishBoss(level, true);
            return false;
        }
        if (!boss.get().m_6084_()) {
            this.finishBossWithReward((LivingEntity)boss.get(), level);
            return false;
        }
        BossArenaManager arenaManager = new BossArenaManager(this.blockEntity);
        if (boss.get().m_20186_() < (double)arenaManager.getBossPlacement().m_6625_(3).m_123342_()) {
            boss.get().m_146870_();
            this.finishBoss(level, true);
            return false;
        }
        return true;
    }

    private boolean checkPlayers(ServerLevel level) {
        List<ServerPlayer> players = this.blockEntity.getPlayers();
        BossArenaManager arenaManager = new BossArenaManager(this.blockEntity);
        for (ServerPlayer player : players) {
            if (player.m_21224_()) {
                this.blockEntity.removePlayer(player);
                continue;
            }
            if (!(player.m_20186_() < (double)arenaManager.getBossPlacement().m_6625_(3).m_123342_())) continue;
            this.movePlayerBack(player);
            EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.BOSS_FAIL.get(), 1.0f);
            this.blockEntity.removePlayer(player);
        }
        if (this.blockEntity.getPlayers().isEmpty()) {
            this.blockEntity.findBoss().ifPresent(Entity::m_146870_);
            this.finishBoss(level, true);
            return false;
        }
        return true;
    }

    private void finishBoss(ServerLevel level, boolean playFailMusic) {
        BlockPos pos = this.blockEntity.m_58899_();
        new BossArenaManager(this.blockEntity).destroy();
        this.blockEntity.getPlayers().forEach(this::movePlayerBack);
        if (playFailMusic) {
            WorldUtils.playSound((Level)level, (SoundEvent)Sounds.BOSS_FAIL.get(), pos, 1.0f);
        }
        this.blockEntity.resetCooldown();
    }

    private void finishBossWithReward(LivingEntity boss, ServerLevel level) {
        this.finishBoss(level, false);
        BlockPos pos = this.blockEntity.m_58899_();
        WorldUtils.playSound((Level)level, (SoundEvent)Sounds.BOSS_SUCCEED.get(), pos, 1.0f);
        List<ItemStack> loot = new BossLootGenerator().getLoot(boss, level);
        loot.forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
    }

    private void movePlayerBack(ServerPlayer player) {
        BlockPos center = this.blockEntity.getPlayerSpawnPosition(player);
        player.m_6021_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_());
    }
}

