/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.boss;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.blocks.BossSpawnerBlock;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.block.GahAnimatedLevelBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.ITickingBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossFightGoal;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerState;
import com.dee12452.gahoodrpg.common.entities.block.boss.PlayerBossFighter;
import com.dee12452.gahoodrpg.common.entities.block.boss.PreparePlayersGoal;
import com.dee12452.gahoodrpg.common.entities.block.boss.SpawnBossGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientStopSound;
import com.dee12452.gahoodrpg.common.registries.BlockEntityRegistry;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BossSpawnerBlockEntity
extends GahAnimatedLevelBlockEntity
implements ITickingBlockEntity {
    private static final int COOLDOWN_TICKS = TimeUtils.secondsToTicks(10.0f);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.boss_spawner.idle");
    private static final RawAnimation ACTIVE_ANIMATION = RawAnimation.begin().thenLoop("animation.boss_spawner.active");
    private static final RawAnimation COOLDOWN_ANIMATION = RawAnimation.begin().thenLoop("animation.boss_spawner.cooldown");
    @Nullable
    private GoalSelector goalSelector;
    @Nullable
    private UUID bossId;
    private final Set<PlayerBossFighter> players = new HashSet<PlayerBossFighter>();
    private final Cooldown cooldown = new Cooldown(COOLDOWN_TICKS);

    public BossSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BOSS_SPAWNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.serverTick(serverLevel, pos, state);
        } else {
            this.clientTick(level, pos, state);
        }
    }

    public boolean start(Player player, int tier) {
        if (this.getState() != BossSpawnerState.IDLE || !this.cooldown.check((LivingEntity)player)) {
            return false;
        }
        this.setTier(tier);
        this.setState(BossSpawnerState.PREPARING);
        return true;
    }

    public void resetCooldown() {
        this.getCooldown().reset(this.getLevelUnsafe());
        this.setState(BossSpawnerState.COOLDOWN);
    }

    public Cooldown getCooldown() {
        return this.cooldown;
    }

    public void setBossId(@Nullable UUID bossId) {
        this.bossId = bossId;
    }

    public Optional<GahBossBase<?, ?>> findBoss() {
        ServerLevel level = (ServerLevel)this.getLevelUnsafe();
        return Optional.ofNullable(this.bossId).map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(e -> e instanceof GahBossBase).map(e -> (GahBossBase)e);
    }

    public List<ServerPlayer> getPlayers() {
        Level level = this.getLevelUnsafe();
        return this.players.stream().map(p -> p.playerId).filter(Objects::nonNull).map(arg_0 -> ((Level)level).m_46003_(arg_0)).filter(Objects::nonNull).map(p -> (ServerPlayer)p).toList();
    }

    public BlockPos getPlayerSpawnPosition(ServerPlayer player) {
        return this.players.stream().filter(p -> Objects.equals(p.playerId, player.m_20148_())).findFirst().map(p -> p.playerOrigin).orElse(this.m_58899_());
    }

    public void setPlayers(List<ServerPlayer> players) {
        this.players.clear();
        this.players.addAll(players.stream().map(PlayerBossFighter::new).toList());
    }

    public void removePlayer(ServerPlayer player) {
        this.players.remove(new PlayerBossFighter(player));
        this.findBoss().ifPresent(boss -> boss.removePlayer(player));
        NetworkChannel.sendToClient(player, new ClientStopSound.Message((SoundEvent)Sounds.BOSS_MUSIC.get(), SoundSource.MUSIC));
    }

    public int getTier() {
        return (Integer)this.m_58900_().m_61143_((Property)BossSpawnerBlock.BOSS_SPAWNER_TIER);
    }

    public void setTier(int tier) {
        this.getLevelUnsafe().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BossSpawnerBlock.BOSS_SPAWNER_TIER, (Comparable)Integer.valueOf(tier)), 3);
    }

    public BossSpawnerState getState() {
        return (BossSpawnerState)((Object)this.m_58900_().m_61143_(BossSpawnerBlock.BOSS_SPAWNER_STATE_PROPERTY));
    }

    public void setState(BossSpawnerState state) {
        this.getLevelUnsafe().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(BossSpawnerBlock.BOSS_SPAWNER_STATE_PROPERTY, (Comparable)((Object)state)), 3);
    }

    public Level getLevelUnsafe() {
        return Optional.ofNullable(this.m_58904_()).orElseThrow();
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooldown.deserializeNBT(nbt.m_128469_("cooldown"));
        if (nbt.m_128441_("bossId")) {
            this.bossId = nbt.m_128342_("bossId");
        }
        this.players.clear();
        int playerSize = nbt.m_128451_("playerSize");
        for (int idx = 0; idx < playerSize; ++idx) {
            PlayerBossFighter player = new PlayerBossFighter();
            player.deserializeNBT(nbt.m_128469_(String.format("playerId%d", idx)));
            this.players.add(player);
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("cooldown", (Tag)this.cooldown.serializeNBT());
        Optional.ofNullable(this.bossId).ifPresent(id -> nbt.m_128362_("bossId", id));
        nbt.m_128405_("playerSize", this.players.size());
        int idx = 0;
        for (PlayerBossFighter id2 : this.players) {
            nbt.m_128365_(String.format("playerId%d", idx), (Tag)id2.serializeNBT());
            ++idx;
        }
    }

    @Override
    @Nullable
    protected PlayState handleAnimation(AnimationState<GahAnimatedLevelBlockEntity> state) {
        switch (this.getState()) {
            case IDLE: {
                return state.setAndContinue(IDLE_ANIMATION);
            }
            case COOLDOWN: {
                return state.setAndContinue(COOLDOWN_ANIMATION);
            }
        }
        return state.setAndContinue(ACTIVE_ANIMATION);
    }

    private void serverTick(ServerLevel level, BlockPos pos, BlockState state) {
        this.getGoalSelector((Level)level).m_25373_();
        if (this.cooldown.check((Level)level) && this.getState() == BossSpawnerState.COOLDOWN) {
            this.setState(BossSpawnerState.IDLE);
        }
    }

    private void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    private void registerGoals(GoalSelector goalSelector) {
        goalSelector.m_25352_(1, (Goal)new PreparePlayersGoal(this));
        goalSelector.m_25352_(2, (Goal)new SpawnBossGoal(this));
        goalSelector.m_25352_(3, (Goal)new BossFightGoal(this));
    }

    private GoalSelector getGoalSelector(Level level) {
        if (this.goalSelector == null) {
            this.goalSelector = new GoalSelector(level.m_46658_());
            this.registerGoals(this.goalSelector);
        }
        return this.goalSelector;
    }
}

