/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.boss;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerState;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.AABB;

public class PreparePlayersGoal
extends Goal {
    private static final int PREPARE_TICKS = TimeUtils.secondsToTicks(5.0f);
    private final BossSpawnerBlockEntity blockEntity;
    private int ticks = 0;
    private final ServerBossEvent event = new ServerBossEvent((Component)Component.m_237115_((String)"boss.gahoodrpg.preparing"), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);

    public PreparePlayersGoal(BossSpawnerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public boolean m_8036_() {
        return this.blockEntity.getState() == BossSpawnerState.PREPARING;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        return this.event.m_142717_() > 0.0f;
    }

    public void m_8056_() {
        super.m_8056_();
        this.blockEntity.setPlayers(Lists.newArrayList());
        this.event.m_142711_(1.0f);
        this.ticks = 0;
        WorldUtils.playSound(this.blockEntity.getLevelUnsafe(), (SoundEvent)Sounds.BOSS_ENGAGE.get(), this.blockEntity.m_58899_(), 1.0f);
    }

    public void m_8041_() {
        super.m_8041_();
        List players = this.event.m_8324_().stream().toList();
        if (players.isEmpty()) {
            this.blockEntity.resetCooldown();
            return;
        }
        this.blockEntity.setPlayers(this.event.m_8324_().stream().toList());
        this.event.m_7706_();
        this.blockEntity.setState(BossSpawnerState.SPAWNING);
    }

    public void m_8037_() {
        super.m_8037_();
        ServerLevel level = (ServerLevel)this.blockEntity.getLevelUnsafe();
        if (this.ticks % 5 == 0) {
            this.locatePlayers(level);
        }
        this.updateProgress();
        ++this.ticks;
    }

    private void locatePlayers(ServerLevel level) {
        this.event.m_7706_();
        AABB box = new AABB(this.blockEntity.m_58899_()).m_82400_(3.0);
        EntityUtils.getTargetablePlayers(level, box).stream().sorted(Comparator.comparingDouble(player -> player.m_20238_(this.blockEntity.m_58899_().m_252807_()))).limit(4L).forEach(arg_0 -> ((ServerBossEvent)this.event).m_6543_(arg_0));
    }

    private void updateProgress() {
        float newProgress = Math.max(0.0f, 1.0f - (float)this.ticks / (float)PREPARE_TICKS);
        this.event.m_142711_(newProgress);
    }
}

