/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.boss;

import com.dee12452.gahoodrpg.common.entities.block.boss.BossArenaManager;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.boss.BossSpawnerState;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.common.items.BossSpawnItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;

public class SpawnBossGoal
extends Goal {
    private final BossSpawnerBlockEntity blockEntity;

    public SpawnBossGoal(BossSpawnerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public boolean m_8036_() {
        return !this.blockEntity.getPlayers().isEmpty() && this.blockEntity.getState() == BossSpawnerState.SPAWNING;
    }

    public void m_8056_() {
        super.m_8056_();
        ServerLevel level = (ServerLevel)this.blockEntity.getLevelUnsafe();
        BossArenaManager arenaManager = new BossArenaManager(this.blockEntity);
        arenaManager.create();
        this.placePlayers(arenaManager);
        if (!this.spawnBoss(level, arenaManager)) {
            this.blockEntity.resetCooldown();
            return;
        }
        this.blockEntity.setState(BossSpawnerState.FIGHTING);
    }

    private boolean spawnBoss(ServerLevel level, BossArenaManager arenaManager) {
        int tier = this.blockEntity.getTier();
        GahBossBase boss = (GahBossBase)BossSpawnItem.getBossType(tier).m_262496_(level, arenaManager.getBossPlacement(), MobSpawnType.MOB_SUMMONED);
        if (boss == null) {
            return false;
        }
        this.blockEntity.getPlayers().forEach(boss::addPlayer);
        this.blockEntity.setBossId(boss.m_20148_());
        boss.scaleHealthToPlayers();
        return true;
    }

    private void placePlayers(BossArenaManager arenaManager) {
        List<ServerPlayer> players = this.blockEntity.getPlayers();
        BlockPos bossPos = arenaManager.getBossPlacement();
        players.forEach(player -> {
            RandomSource random = player.m_217043_();
            int randX = random.m_188503_(10) * (random.m_188499_() ? 1 : -1);
            int randZ = random.m_188503_(10) * (random.m_188499_() ? 1 : -1);
            player.m_6021_((double)(bossPos.m_123341_() + randX), (double)bossPos.m_123342_(), (double)(bossPos.m_123343_() + randZ));
        });
    }
}

