/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.horde;

import com.dee12452.gahoodrpg.common.entities.block.horde.HordeDifficulty;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeIdentifier;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeLocation;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeWave;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;

public class HordeGenerator {
    private static final int MAX_Y_SPAWN = 128;
    public static final double HORDE_RADIUS = 25.0;
    private static final List<EntityType<? extends Mob>> VANILLA_MONSTERS = Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20524_, EntityType.f_20501_, EntityType.f_20558_, EntityType.f_20479_});
    private static final List<EntityType<? extends Mob>> TIER_1_MONSTERS = Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.ENRAGED_ZOMBIE.get(), (EntityType)LivingEntityRegistry.ENRAGED_SKELETON.get(), (EntityType)LivingEntityRegistry.ENRAGED_CREEPER.get(), (EntityType)LivingEntityRegistry.ENRAGED_SPIDER.get()});
    private static final List<EntityType<? extends Mob>> TIER_2_EASY_MONSTERS = Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.SCORPION.get(), (EntityType)LivingEntityRegistry.SPHINX.get()});
    private static final List<EntityType<? extends Mob>> TIER_2_HARD_MONSTERS = Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.CAVE_SCORPION.get(), (EntityType)LivingEntityRegistry.CRAZED_ARCHEOLOGIST.get()});
    private static final List<EntityType<? extends Mob>> TIER_3_FROGS = Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.POISONOUS_FROG.get()});
    private static final List<EntityType<? extends Mob>> TIER_3_CHOMPLANTS = Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.CHOMPLANT.get()});
    private static final List<EntityType<? extends Mob>> TIER_3_HARD_MONSTERS = Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.CAMO_SKELETON.get(), (EntityType)LivingEntityRegistry.JAGARIX.get()});
    private static final Map<HordeIdentifier, List<Generator>> HORDES = new HashMap<HordeIdentifier, List<Generator>>(){
        {
            this.put(new HordeIdentifier(1, HordeDifficulty.EASY, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(VANILLA_MONSTERS, 2), rand -> (double)rand.m_188501_() < 0.75 ? new Wave(VANILLA_MONSTERS, 3) : new Wave(Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20551_}), 1), rand -> new Wave(VANILLA_MONSTERS, 4)}));
            this.put(new HordeIdentifier(1, HordeDifficulty.MEDIUM, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(VANILLA_MONSTERS, 3), rand -> (double)rand.m_188501_() < 0.75 ? new Wave(VANILLA_MONSTERS, 4) : new Wave(Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20551_}), 3), rand -> new Wave(TIER_1_MONSTERS, 2)}));
            this.put(new HordeIdentifier(1, HordeDifficulty.HARD, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(TIER_1_MONSTERS, 2), rand -> (double)rand.m_188501_() < 0.75 ? new Wave(TIER_1_MONSTERS, 3) : new Wave(Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20551_}), 5), rand -> new Wave(TIER_1_MONSTERS, 4)}));
            this.put(new HordeIdentifier(2, HordeDifficulty.EASY, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(TIER_1_MONSTERS, 3), rand -> new Wave(TIER_1_MONSTERS, 5), rand -> new Wave(TIER_2_EASY_MONSTERS, 1)}));
            this.put(new HordeIdentifier(2, HordeDifficulty.MEDIUM, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(TIER_2_EASY_MONSTERS, 1), rand -> new Wave(TIER_2_EASY_MONSTERS, 2), rand -> new Wave(TIER_2_HARD_MONSTERS, 2)}));
            this.put(new HordeIdentifier(2, HordeDifficulty.HARD, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(TIER_2_EASY_MONSTERS, 2), rand -> new Wave(TIER_2_HARD_MONSTERS, 3), rand -> new Wave(Stream.concat(TIER_2_EASY_MONSTERS.stream(), TIER_2_HARD_MONSTERS.stream()).collect(Collectors.toList()), 5)}));
            this.put(new HordeIdentifier(3, HordeDifficulty.EASY, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(TIER_2_EASY_MONSTERS, 3), rand -> new Wave(TIER_3_FROGS, 1), rand -> new Wave(TIER_3_FROGS, 2)}));
            this.put(new HordeIdentifier(3, HordeDifficulty.MEDIUM, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(TIER_3_FROGS, 3), rand -> new Wave(TIER_3_CHOMPLANTS, 2), rand -> new Wave(TIER_3_CHOMPLANTS, 3)}));
            this.put(new HordeIdentifier(3, HordeDifficulty.HARD, HordeLocation.ALL), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(Stream.concat(TIER_3_FROGS.stream(), TIER_3_CHOMPLANTS.stream()).collect(Collectors.toList()), 3), rand -> new Wave(TIER_3_HARD_MONSTERS, 3), rand -> new Wave(TIER_3_HARD_MONSTERS, 5)}));
            this.put(new HordeIdentifier(4, HordeDifficulty.HARD, HordeLocation.COLD), Lists.newArrayList((Object[])new Generator[]{rand -> new Wave(Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.FROST_CREEPER.get()}), 3), rand -> new Wave(Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.FROST_SPIDER.get()}), 4), rand -> new Wave(Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20481_}), 3)}));
        }
    };

    public Optional<HordeWave> generateWave(ServerLevel level, BlockPos spawnPos, HordeIdentifier identifier, int waveIndex, List<ServerPlayer> players) {
        if (!HORDES.containsKey(identifier) || players.isEmpty()) {
            return Optional.empty();
        }
        List<Generator> waves = HORDES.get(identifier);
        if (waveIndex >= waves.size()) {
            return Optional.empty();
        }
        RandomSource defaultRandom = players.get(0).m_217043_();
        Supplier<ServerPlayer> randomPlayerSupplier = () -> (ServerPlayer)players.get(defaultRandom.m_188503_(players.size()));
        ArrayList<Mob> waveMobs = new ArrayList<Mob>();
        Wave wave = waves.get(waveIndex).generate(defaultRandom);
        for (int times = 0; times < wave.mobNumber(); ++times) {
            int nextMonsterIdx = defaultRandom.m_188503_(wave.mobTypes().size());
            EntityType<? extends Mob> nextMonsterType = wave.mobTypes().get(nextMonsterIdx);
            BlockPos nextSpawnPos = this.findValidSpawnSpot(level, spawnPos);
            Mob newMonster = (Mob)nextMonsterType.m_262496_(level, nextSpawnPos, MobSpawnType.SPAWNER);
            Optional.ofNullable(newMonster).ifPresent(m -> {
                ServerPlayer randomTarget = (ServerPlayer)randomPlayerSupplier.get();
                m.m_6710_((LivingEntity)randomTarget);
                m.m_21561_(true);
                waveMobs.add((Mob)m);
            });
        }
        return Optional.of(new HordeWave(waveMobs, waveIndex));
    }

    private BlockPos findValidSpawnSpot(ServerLevel level, BlockPos spawnPos) {
        RandomSource random = level.m_213780_();
        int x = spawnPos.m_123341_() + (random.m_188499_() ? 1 : -1) * random.m_188503_(12);
        int z = spawnPos.m_123343_() + (random.m_188499_() ? 1 : -1) * random.m_188503_(12);
        BlockPos spawnSpot = new BlockPos(x, spawnPos.m_123342_(), z);
        while (!level.m_8055_(spawnSpot).m_60795_() && spawnSpot.m_123342_() < 128) {
            spawnSpot = spawnSpot.m_7494_();
        }
        if (spawnSpot.m_123342_() >= 128) {
            return spawnPos.m_7494_();
        }
        return spawnSpot;
    }

    @FunctionalInterface
    private static interface Generator {
        public Wave generate(RandomSource var1);
    }

    private record Wave(List<EntityType<? extends Mob>> mobTypes, int mobNumber) {
    }
}

