/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.horde;

import com.dee12452.gahoodrpg.common.blocks.HordeSpawnerBlock;
import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.block.GahAnimatedLevelBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.ITickingBlockEntity;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeDifficulty;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeGenerator;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeIdentifier;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeLocation;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeLootGenerator;
import com.dee12452.gahoodrpg.common.entities.block.horde.HordeWave;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSpawnParticles;
import com.dee12452.gahoodrpg.common.registries.BlockEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HordeSpawnerBlockEntity
extends GahAnimatedLevelBlockEntity
implements ITickingBlockEntity {
    private static final String DISPLAY_NAME = "gahoodrpg.horde.name";
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.horde_spawner.idle");
    private static final RawAnimation ACTIVE_ANIMATION = RawAnimation.begin().thenLoop("animation.horde_spawner.active");
    private static final RawAnimation COOLDOWN_ANIMATION = RawAnimation.begin().thenLoop("animation.horde_spawner.cooldown");
    private static final int COOLDOWN_TICKS = TimeUtils.secondsToTicks(300.0f);
    @Nullable
    private HordeDifficulty difficulty;
    @Nullable
    private Cooldown cooldown;
    @Nullable
    private HordeWave hordeWave;
    private int activeTick = 0;
    private final List<UUID> playerUUIDs;
    private final HordeGenerator hordeGenerator;
    private final HordeLootGenerator hordeLootGenerator;
    private final ServerBossEvent event = new ServerBossEvent((Component)Component.m_237115_((String)"gahoodrpg.horde.name"), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    private HordeIdentifier hordeIdentifier;
    private int currentWaveIdx;
    private boolean lootDropped;

    public HordeSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.HORDE_SPAWNER_BLOCK_ENTITY.get(), pos, state);
        this.playerUUIDs = new ArrayList<UUID>();
        this.hordeGenerator = new HordeGenerator();
        this.hordeLootGenerator = new HordeLootGenerator();
        this.hordeIdentifier = new HordeIdentifier((Integer)state.m_61143_((Property)HordeSpawnerBlock.HORDE_TIER), HordeDifficulty.fromBlockState(state), HordeLocation.fromBlockState(state));
        this.currentWaveIdx = 0;
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int difficultyValue = this.difficulty == null ? this.generateDifficulty(serverLevel) : this.difficulty.ordinal();
        this.updateDifficulty(difficultyValue);
        if (this.cooldown == null) {
            this.cooldown = new Cooldown(COOLDOWN_TICKS);
            this.cooldown.forceReady((Level)serverLevel);
        }
    }

    public boolean start(Player player, BlockState state) {
        if (player.m_5833_() || player.m_7500_()) {
            return false;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.isEnabled(state) || !this.checkCooldown((Level)serverLevel)) {
            return false;
        }
        this.reset();
        this.setEnabled((Level)serverLevel, this.m_58899_(), this.m_58900_());
        this.findPlayers(serverLevel).forEach(p -> {
            this.playerUUIDs.add(p.m_20148_());
            this.event.m_6543_(p);
        });
        this.generateNextWave(serverLevel, this.m_58899_());
        return true;
    }

    public void m_7651_() {
        super.m_7651_();
        this.reset();
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.updateState(level, pos, state);
        if (!this.isEnabled(state)) {
            this.reset();
            return;
        }
        this.tickWaveMobs(serverLevel, pos, state);
        this.tickPlayers(serverLevel, pos, state);
        ++this.activeTick;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        int playersSize = nbt.m_128451_("playerUuidsSize");
        for (int idx = 0; idx < playersSize; ++idx) {
            this.playerUUIDs.add(nbt.m_128342_(String.format("playerUUID%d", idx)));
        }
        this.currentWaveIdx = nbt.m_128451_("currentWaveIdx");
        this.activeTick = nbt.m_128451_("activeTick");
        this.lootDropped = nbt.m_128471_("lootDropped");
        if (nbt.m_128441_("hordeWave")) {
            this.hordeWave = new HordeWave();
            this.hordeWave.deserializeNBT(nbt.m_128469_("hordeWave"));
        }
        if (nbt.m_128441_("difficulty")) {
            this.difficulty = HordeDifficulty.values()[nbt.m_128451_("difficulty")];
        }
        if (nbt.m_128441_("cooldown")) {
            this.cooldown = new Cooldown(COOLDOWN_TICKS);
            this.cooldown.deserializeNBT(nbt.m_128469_("cooldown"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("playerUuidsSize", this.playerUUIDs.size());
        for (int idx = 0; idx < this.playerUUIDs.size(); ++idx) {
            nbt.m_128362_(String.format("playerUUID%d", idx), this.playerUUIDs.get(idx));
        }
        nbt.m_128405_("currentWaveIdx", this.currentWaveIdx);
        nbt.m_128405_("activeTick", this.activeTick);
        nbt.m_128379_("lootDropped", this.lootDropped);
        Optional.ofNullable(this.hordeWave).ifPresent(h -> nbt.m_128365_("hordeWave", (Tag)h.serializeNBT()));
        Optional.ofNullable(this.difficulty).ifPresent(d -> nbt.m_128405_("difficulty", this.difficulty.ordinal()));
        Optional.ofNullable(this.cooldown).ifPresent(cd -> nbt.m_128365_("cooldown", (Tag)this.cooldown.serializeNBT()));
    }

    @Override
    @Nullable
    protected PlayState handleAnimation(AnimationState<GahAnimatedLevelBlockEntity> state) {
        if (this.isEnabled(this.m_58900_())) {
            return state.setAndContinue(ACTIVE_ANIMATION);
        }
        boolean onCooldown = (Boolean)this.m_58900_().m_61143_((Property)HordeSpawnerBlock.HORDE_COOLDOWN);
        if (onCooldown) {
            return state.setAndContinue(COOLDOWN_ANIMATION);
        }
        return state.setAndContinue(IDLE_ANIMATION);
    }

    private List<ServerPlayer> findPlayers(ServerLevel level) {
        return EntityUtils.getTargetablePlayers(level, this.getArea());
    }

    private void generateNextWave(ServerLevel level, BlockPos pos) {
        this.event.m_6456_((Component)Component.m_237110_((String)DISPLAY_NAME, (Object[])new Object[]{this.hordeIdentifier.difficulty().name(), this.currentWaveIdx + 1}));
        this.hordeWave = this.hordeGenerator.generateWave(level, pos, this.hordeIdentifier, this.currentWaveIdx, this.findPlayers(level)).orElse(null);
        ++this.currentWaveIdx;
    }

    private void updateDifficulty(int difficultyValue) {
        this.difficulty = HordeDifficulty.values()[difficultyValue];
        if (this.difficulty == null) {
            return;
        }
        int tier = this.hordeIdentifier.tier();
        HordeLocation location = this.hordeIdentifier.location();
        this.hordeIdentifier = new HordeIdentifier(tier, this.difficulty, location);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)HordeSpawnerBlock.HORDE_DIFFICULTY, (Comparable)Integer.valueOf(difficultyValue)), 3);
        }
    }

    private void tickWaveMobs(ServerLevel serverLevel, BlockPos pos, BlockState state) {
        if (this.hordeWave == null) {
            if (!this.lootDropped) {
                this.dropLoot(serverLevel, pos);
                this.lootDropped = true;
                this.setDisabled((Level)serverLevel, pos, state);
            }
            return;
        }
        if (this.hordeWave.isDone(serverLevel)) {
            this.generateNextWave(serverLevel, pos);
            return;
        }
        AABB hordeArea = this.getArea();
        for (Mob mob : this.hordeWave.getLivingMobs(serverLevel)) {
            if (mob.m_6060_()) {
                mob.m_20095_();
            }
            if (!hordeArea.m_82381_(mob.m_20191_())) {
                mob.m_20035_(pos.m_7494_(), mob.m_146908_(), mob.m_146909_());
            }
            if (mob.m_217043_().m_188503_(30) != 0) continue;
            this.playerUUIDs.stream().map(arg_0 -> ((ServerLevel)serverLevel).m_46003_(arg_0)).filter(Objects::nonNull).forEach(player -> Lists.newArrayList((Object[])new BlockPos[]{mob.m_20183_(), mob.m_20183_().m_7494_()}).forEach(pPos -> NetworkChannel.sendToClient((ServerPlayer)player, new ClientSpawnParticles.Message("#f2ff42", (BlockPos)pPos))));
        }
        this.event.m_142711_(this.hordeWave.getProgress(serverLevel));
    }

    private void dropLoot(ServerLevel level, BlockPos pos) {
        List<ItemStack> drops = this.hordeLootGenerator.getLoot(level, this.hordeIdentifier);
        drops.forEach(drop -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)drop));
    }

    private boolean isEnabled(BlockState state) {
        try {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61431_);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void setEnabled(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.TRUE), 3);
    }

    private void setDisabled(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61431_, (Comparable)Boolean.FALSE), 3);
        if (this.cooldown != null) {
            this.cooldown.reset(level);
        }
    }

    private void tickPlayers(ServerLevel level, BlockPos pos, BlockState state) {
        if (level.m_7654_().m_7416_() == 0) {
            return;
        }
        ArrayList<UUID> playerUUIDsToKeep = new ArrayList<UUID>();
        List<ServerPlayer> playersInArea = this.findPlayers(level);
        for (UUID playerUUID : this.playerUUIDs) {
            boolean keep = false;
            for (ServerPlayer playerInArea : playersInArea) {
                if (!playerInArea.m_20148_().equals(playerUUID)) continue;
                keep = true;
                break;
            }
            if (!keep) continue;
            playerUUIDsToKeep.add(playerUUID);
        }
        Runnable eventPlayerUpdate = () -> {
            this.event.m_7706_();
            this.playerUUIDs.stream().map(arg_0 -> ((ServerLevel)level).m_46003_(arg_0)).map(p -> (ServerPlayer)p).filter(Objects::nonNull).forEach(arg_0 -> ((ServerBossEvent)this.event).m_6543_(arg_0));
        };
        if (playerUUIDsToKeep.size() == this.playerUUIDs.size()) {
            if (this.event.m_8324_().size() != this.playerUUIDs.size()) {
                eventPlayerUpdate.run();
            }
            return;
        }
        if (playerUUIDsToKeep.isEmpty()) {
            this.playerUUIDs.clear();
            this.setDisabled((Level)level, pos, state);
            return;
        }
        this.playerUUIDs.clear();
        this.playerUUIDs.addAll(playerUUIDsToKeep);
        eventPlayerUpdate.run();
    }

    private void updateState(Level level, BlockPos pos, BlockState state) {
        boolean stateOffCooldown;
        boolean offCooldown = this.checkCooldown(level);
        boolean bl = stateOffCooldown = (Boolean)state.m_61143_((Property)HordeSpawnerBlock.HORDE_COOLDOWN) == false;
        if (offCooldown == stateOffCooldown) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HordeSpawnerBlock.HORDE_COOLDOWN, (Comparable)Boolean.valueOf(!offCooldown)), 3);
    }

    private void reset() {
        this.activeTick = 0;
        this.currentWaveIdx = 0;
        this.lootDropped = false;
        this.clearPlayers();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.hordeWave != null) {
                this.hordeWave.clear(serverLevel);
            }
        }
        this.event.m_142711_(1.0f);
    }

    private void clearPlayers() {
        this.event.m_7706_();
        this.playerUUIDs.clear();
    }

    private AABB getArea() {
        return new AABB(this.m_58899_()).m_82400_(25.0);
    }

    private boolean checkCooldown(Level level) {
        return Optional.ofNullable(this.cooldown).map(cd -> cd.check(level)).orElse(false);
    }

    private int generateDifficulty(ServerLevel serverLevel) {
        if (this.hordeIdentifier.location() == HordeLocation.COLD) {
            return HordeDifficulty.HARD.ordinal();
        }
        return serverLevel.m_213780_().m_188503_(HordeDifficulty.HARD.ordinal() + 1);
    }
}

