/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.block.horde;

import com.dee12452.gahoodrpg.utils.NbtUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.util.INBTSerializable;

public class HordeWave
implements INBTSerializable<CompoundTag> {
    private int waveIndex;
    private int totalMobs;
    private List<UUID> waveMobs;

    public HordeWave() {
        this(new ArrayList<Mob>(), 0);
    }

    public HordeWave(List<Mob> mobs, int waveIndex) {
        this.waveMobs = mobs.stream().map(Entity::m_20148_).toList();
        this.waveIndex = waveIndex;
        this.totalMobs = mobs.size();
    }

    public boolean isDone(ServerLevel level) {
        return this.getLivingMobs(level).isEmpty();
    }

    public float getProgress(ServerLevel level) {
        if (this.totalMobs == 0) {
            return 0.0f;
        }
        return (float)this.getLivingMobs(level).size() / (float)this.totalMobs;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("waveIndex", this.waveIndex);
        nbt.m_128405_("totalMobs", this.totalMobs);
        NbtUtils.writeList(nbt, "waveMobs", this.waveMobs, CompoundTag::m_128362_);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.waveIndex = nbt.m_128451_("waveIndex");
        this.totalMobs = nbt.m_128451_("totalMobs");
        this.waveMobs = NbtUtils.readList(nbt, "waveMobs", CompoundTag::m_128342_);
    }

    public List<Mob> getLivingMobs(ServerLevel level) {
        return this.waveMobs.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(Objects::nonNull).map(e -> (Mob)e).filter(LivingEntity::m_6084_).toList();
    }

    public void clear(ServerLevel level) {
        this.getLivingMobs(level).forEach(Entity::m_146870_);
        this.totalMobs = 0;
    }
}

