/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahMonsterBase;
import com.dee12452.gahoodrpg.common.entities.living.ai.SerializableCooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.ai.SerializableGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.ItemProjectile;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.RawAnimation;

public class AngrySnowman
extends GahMonsterBase<State, AnimationState> {
    private SerializableGoal throwGoal;
    private INBTSerializable<CompoundTag> meleeGoal;

    public AngrySnowman(EntityType<? extends AngrySnowman> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("throwGoal", this.throwGoal.serializeNBT());
        nbt.m_128365_("meleeGoal", this.meleeGoal.serializeNBT());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.throwGoal.deserializeNBT((Tag)nbt.m_128469_("throwGoal"));
        this.meleeGoal.deserializeNBT((Tag)nbt.m_128469_("meleeGoal"));
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.m_6710_((LivingEntity)player);
            this.m_21561_(true);
        }
        return super.m_6469_(source, p_21017_);
    }

    @Override
    protected AnimationState valueToAnimationState(int value) {
        return AnimationState.values()[value];
    }

    @Override
    protected State valueToEntityState(int value) {
        return State.values()[value];
    }

    protected void m_8099_() {
        super.m_8099_();
        this.throwGoal = new ThrowGoal();
        this.meleeGoal = new MeleeGoal();
        this.f_21345_.m_25352_(1, (Goal)this.throwGoal);
        this.f_21345_.m_25352_(2, (Goal)this.meleeGoal);
    }

    public static enum AnimationState implements GahAnimationState
    {
        IDLE(RawAnimation.begin().thenPlayAndHold("animation.angry_snowman.idle")),
        WALK(RawAnimation.begin().thenLoop("animation.angry_snowman.move")),
        THROW(RawAnimation.begin().thenPlayAndHold("animation.angry_snowman.throw"), TimeUtils.secondsToTicks(0.70833f)),
        MELEE(RawAnimation.begin().thenPlayAndHold("animation.angry_snowman.hit"), TimeUtils.secondsToTicks(0.79167f));

        private final RawAnimation animation;
        private final int duration;

        private AnimationState(RawAnimation animation) {
            this(animation, -1);
        }

        private AnimationState(RawAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }

    public static enum State implements GahEntityState
    {
        IDLE,
        THROW,
        MELEE;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class ThrowGoal
    extends SerializableCooldownGoal {
        private int goalTicks;

        public ThrowGoal() {
            super(TimeUtils.secondsToTicks(3.0f));
        }

        public boolean m_8036_() {
            ArrayList checks;
            if (AngrySnowman.this.getEntityState() == State.THROW) {
                return true;
            }
            if (!AngrySnowman.this.m_5912_() && AngrySnowman.this.rollRandom(10)) {
                this.findRandomPlayerTarget();
            }
            if (AngrySnowman.this.allChecksPass(checks = Lists.newArrayList((Object[])new Boolean[]{!AngrySnowman.this.m_5912_(), AngrySnowman.this.getPlayerTarget().isPresent(), AngrySnowman.this.getEntityState() == State.IDLE, this.cooldown.checkAndReset((LivingEntity)AngrySnowman.this)}))) {
                AngrySnowman.this.setEntityState(State.THROW);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return AngrySnowman.this.getPlayerTarget().isPresent() && this.goalTicks < AnimationState.THROW.duration;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            AngrySnowman.this.getPlayerTarget().ifPresent(p -> AngrySnowman.this.forceYRot(((Float)EntityUtils.getRotationTo((LivingEntity)AngrySnowman.this, (LivingEntity)p).getLeft()).floatValue()));
            ++this.goalTicks;
        }

        public void m_8056_() {
            super.m_8056_();
            AngrySnowman.this.setAnimationState(AnimationState.THROW);
            AngrySnowman.this.m_21561_(true);
            this.goalTicks = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            AngrySnowman.this.setEntityState(State.IDLE);
            AngrySnowman.this.setAnimationState(AnimationState.IDLE);
            AngrySnowman.this.m_21561_(false);
            Optional<ServerPlayer> player = AngrySnowman.this.getPlayerTarget();
            if (player.isEmpty()) {
                return;
            }
            ItemProjectile snowball = new ItemProjectile((EntityType<? extends ItemProjectile>)((EntityType)ProjectileEntityRegistry.ANGRY_SNOWMAN_SNOWBALL.get()), (LivingEntity)AngrySnowman.this, 0.002f, SoundEvents.f_12481_, SoundEvents.f_12481_);
            float speed = 2.0f;
            Pair<Float, Float> rotationTo = EntityUtils.getRotationTo((LivingEntity)AngrySnowman.this, (LivingEntity)player.get());
            snowball.m_37251_((Entity)AngrySnowman.this, ((Float)rotationTo.getRight()).floatValue(), ((Float)rotationTo.getLeft()).floatValue(), 0.0f, 2.0f, 0.0f);
            AngrySnowman.this.m_9236_().m_7967_((Entity)snowball);
        }

        private void findRandomPlayerTarget() {
            ServerLevel level = (ServerLevel)AngrySnowman.this.m_9236_();
            double followRange = AngrySnowman.this.getAttributeUnsafe(Attributes.f_22277_).m_22135_();
            AABB searchBox = AngrySnowman.this.m_20191_().m_82377_(followRange, 2.0, followRange);
            List<ServerPlayer> possibleTargets = EntityUtils.getTargetablePlayers(level, searchBox).stream().filter(this::isPlayerLookingAway).toList();
            if (!possibleTargets.isEmpty()) {
                AngrySnowman.this.m_6710_((LivingEntity)possibleTargets.get(AngrySnowman.this.m_217043_().m_188503_(possibleTargets.size())));
            } else {
                AngrySnowman.this.m_6710_(null);
            }
        }

        private boolean isPlayerLookingAway(ServerPlayer player) {
            AABB playerBox = new AABB(player.m_20183_().m_175288_((int)player.m_20188_()));
            double distanceTo = EntityUtils.getDistanceToEntity((LivingEntity)player, (Entity)AngrySnowman.this);
            Vec3 lookAngle = player.m_20154_();
            AABB resultBox = playerBox.m_82369_(lookAngle.m_82490_(distanceTo)).m_82377_(2.0, 1.0, 2.0);
            return !resultBox.m_82381_(AngrySnowman.this.m_20191_());
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("goalTicks", this.goalTicks);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag compoundTag) {
            super.deserializeNBT(compoundTag);
            this.goalTicks = compoundTag.m_128451_("goalTicks");
        }
    }

    private class MeleeGoal
    extends MeleeAttackGoal
    implements INBTSerializable<CompoundTag> {
        private int goalTicks;

        public MeleeGoal() {
            super((PathfinderMob)AngrySnowman.this, 1.0, true);
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{AngrySnowman.this.getEntityState() == State.IDLE, AngrySnowman.this.m_5912_(), super.m_8036_()});
            if (AngrySnowman.this.allChecksPass(checks)) {
                AngrySnowman.this.setEntityState(State.MELEE);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            AngrySnowman.this.setAnimationState(AnimationState.WALK);
            this.goalTicks = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            AngrySnowman.this.setAnimationState(AnimationState.IDLE);
            AngrySnowman.this.setEntityState(State.IDLE);
        }

        public void m_8037_() {
            if (AngrySnowman.this.getAnimationState() == AnimationState.MELEE) {
                ++this.goalTicks;
                if (this.goalTicks >= AnimationState.MELEE.duration && AngrySnowman.this.m_5448_() != null) {
                    AngrySnowman.this.m_7327_((Entity)AngrySnowman.this.m_5448_());
                    AngrySnowman.this.setAnimationState(AnimationState.WALK);
                } else {
                    return;
                }
            }
            super.m_8037_();
        }

        protected void m_6739_(@NotNull LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.m_25565_() <= 0) {
                this.m_25563_();
                AngrySnowman.this.setAnimationState(AnimationState.MELEE);
                this.goalTicks = 0;
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("goalTicks", this.goalTicks);
            return nbt;
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            this.goalTicks = compoundTag.m_128451_("goalTicks");
        }
    }
}

