/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.entities.living.IGahAnimatedMob;
import com.dee12452.gahoodrpg.common.items.Items;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Archeologist
extends PathfinderMob
implements IGahAnimatedMob,
Merchant {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.archeologist.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.archeologist.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private State state = State.IDLE;
    private MerchantOffers offers = Archeologist.createOffers();
    @Nullable
    private Player tradingPlayer;

    public Archeologist(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
        this.state = State.values()[state];
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_5545_(@NotNull LevelAccessor levelAccessor, @NotNull MobSpawnType spawnType) {
        return true;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
        if (player == null) {
            this.setState(State.IDLE);
        }
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        return this.offers;
    }

    public void m_6255_(@NotNull MerchantOffers merchantOffers) {
        this.offers = merchantOffers;
    }

    public void m_6996_(@NotNull MerchantOffer merchantOffer) {
    }

    public void m_7713_(@NotNull ItemStack stack) {
        if (!this.m_183595_() || stack.m_41619_()) {
            return;
        }
        this.m_5496_(this.m_7596_(), this.m_6121_(), this.m_6100_());
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int p_45309_) {
    }

    public boolean m_7826_() {
        return false;
    }

    @NotNull
    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_183595_() {
        return this.m_9236_().m_5776_();
    }

    @Override
    public RawAnimation tickAnimation(AnimationState<GeoAnimatable> event) {
        switch (this.state) {
            case WALK: {
                return WALK_ANIMATION;
            }
        }
        return IDLE_ANIMATION;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!this.m_183595_()) {
            this.m_7189_(player);
            this.m_45301_(player, this.m_5446_(), 1);
            this.setState(State.TRADING);
        }
        return InteractionResult.m_19078_((boolean)this.m_183595_());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new ArcheologistRandomMovementGoal());
    }

    private static MerchantOffers createOffers() {
        MerchantOffers offers = new MerchantOffers();
        offers.add((Object)Archeologist.createOffer(new ItemStack((ItemLike)Items.GLIMMERITE.get(), 5), new ItemStack((ItemLike)Items.EMBERSTONE.get())));
        offers.add((Object)Archeologist.createOffer(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42415_, 5), new ItemStack((ItemLike)Items.SUNFIRE_INGOT.get())));
        offers.add((Object)Archeologist.createOffer(new ItemStack((ItemLike)Items.LEAD_INGOT.get(), 5), new ItemStack((ItemLike)Items.PLATINUM_INGOT.get())));
        offers.add((Object)Archeologist.createOffer(new ItemStack((ItemLike)Items.CARNELIAN.get(), 3), new ItemStack((ItemLike)Items.PHOENIXITE.get())));
        return offers;
    }

    private static MerchantOffer createOffer(ItemStack cost, ItemStack result) {
        return new MerchantOffer(cost, ItemStack.f_41583_, result, 0, Integer.MAX_VALUE, 0, 0.0f, 0);
    }

    private void setState(State state) {
        this.setAnimationState(state.ordinal());
    }

    private static enum State {
        IDLE,
        WALK,
        TRADING;

    }

    private class ArcheologistRandomMovementGoal
    extends WaterAvoidingRandomStrollGoal {
        public ArcheologistRandomMovementGoal() {
            super((PathfinderMob)Archeologist.this, 1.0, 0.05f);
        }

        public boolean m_8036_() {
            if (super.m_8036_() && Archeologist.this.state == State.IDLE) {
                Archeologist.this.setState(State.WALK);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && Archeologist.this.state == State.WALK;
        }

        public void m_8041_() {
            super.m_8041_();
            if (Archeologist.this.state == State.WALK) {
                Archeologist.this.setState(State.IDLE);
            }
        }
    }
}

