/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahMonsterBase;
import com.dee12452.gahoodrpg.common.entities.living.ai.FindPlayerTargetGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Chomplant
extends GahMonsterBase<ChomplantState, ChomplantAnimationState> {
    @Nullable
    private UUID baseUUID;
    @Nullable
    private ChomplantBase base;
    @Nullable
    private UUID stemUUID;
    @Nullable
    private ChomplantStem stem;

    public Chomplant(EntityType<? extends GahMonsterBase> entityType, Level level) {
        super(entityType, level);
        this.disableVanillaRotation();
        this.m_20242_(true);
        this.setEntityState(ChomplantState.INIT);
        this.m_146922_(0.0f);
        this.m_146926_(0.0f);
    }

    public void m_142687_(@NotNull Entity.RemovalReason p_276115_) {
        super.m_142687_(p_276115_);
        Optional.ofNullable(this.stem).ifPresent(Entity::m_146870_);
        Optional.ofNullable(this.base).ifPresent(Entity::m_146870_);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        return false;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        Optional.ofNullable(this.base).ifPresent(b -> nbt.m_128362_("baseUUID", b.m_20148_()));
        Optional.ofNullable(this.stem).ifPresent(s -> nbt.m_128362_("stemUUID", s.m_20148_()));
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("baseUUID")) {
            this.baseUUID = nbt.m_128342_("baseUUID");
        }
        if (nbt.m_128441_("stemUUID")) {
            this.stemUUID = nbt.m_128342_("stemUUID");
        }
    }

    @NotNull
    protected AABB m_142242_() {
        return super.m_142242_().m_82386_(0.0, -0.3, 0.0);
    }

    @Override
    protected ChomplantAnimationState valueToAnimationState(int value) {
        return ChomplantAnimationState.values()[value];
    }

    @Override
    protected ChomplantState valueToEntityState(int value) {
        return ChomplantState.values()[value];
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return ((ChomplantAnimationState)this.getAnimationState()).animation();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new ChomplantFindPlayerTargetGoal());
        this.f_21345_.m_25352_(1, (Goal)new ChomplantLocateBaseGoal());
        this.f_21345_.m_25352_(2, (Goal)new ChomplantChaseTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new ChomplantRetractGoal());
    }

    public boolean m_7327_(@NotNull Entity entity) {
        this.doHurtKnockback(entity);
        return super.m_7327_(entity);
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        Entity entity = source.m_7640_();
        if (source.m_7640_() != null) {
            this.doHurtKnockback(entity);
        }
        return super.m_6469_(source, p_21017_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.CHOMPLANT_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return (SoundEvent)Sounds.CHOMPLANT_HURT.get();
    }

    private void doHurtKnockback(Entity entity) {
        Vec3 angle = EntityUtils.getAngleTo((LivingEntity)this, entity).m_82542_(-1.0, -1.0, -1.0);
        double speed = this.m_21133_(Attributes.f_22279_) * 3.0;
        this.m_147240_(speed * angle.f_82479_, speed * angle.f_82480_, speed * angle.f_82481_);
    }

    public static enum ChomplantState implements GahEntityState
    {
        INIT,
        IDLE,
        CHASE;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    public static class ChomplantStem
    extends ChomplantBase {
        private static final EntityDataAccessor<Float> Y_SCALE = SynchedEntityData.m_135353_(ChomplantStem.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        private float initialDistance = 0.0f;

        public ChomplantStem(EntityType<? extends ChomplantStem> entityType, Level level) {
            super((EntityType<? extends ChomplantBase>)entityType, level);
            this.disableVanillaRotation();
            this.setProjectileXRot(0.0f);
            this.setProjectileYRot(0.0f);
        }

        public float getYScale() {
            return ((Float)this.f_19804_.m_135370_(Y_SCALE)).floatValue();
        }

        public void setYScale(float yScale) {
            this.f_19804_.m_135381_(Y_SCALE, (Object)Float.valueOf(yScale));
        }

        @Override
        public void m_8119_() {
            super.m_8119_();
            Entity entity = this.m_19749_();
            if (!(entity instanceof Chomplant)) {
                return;
            }
            Chomplant chomplant = (Chomplant)entity;
            ChomplantBase base = chomplant.base;
            if (base == null) {
                return;
            }
            if (this.f_19797_ % 5 != 0) {
                return;
            }
            this.updateScale(chomplant, base);
            this.updateRotation(chomplant, base);
        }

        @Override
        protected void m_7380_(@NotNull CompoundTag nbt) {
            super.m_7380_(nbt);
            nbt.m_128350_("initialDistance", this.initialDistance);
        }

        @Override
        protected void m_7378_(@NotNull CompoundTag nbt) {
            super.m_7378_(nbt);
            this.initialDistance = nbt.m_128457_("initialDistance");
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(Y_SCALE, (Object)Float.valueOf(1.0f));
        }

        private void updateScale(Chomplant chomplant, ChomplantBase base) {
            Vec3 targetPosition = new Vec3(chomplant.m_20185_(), chomplant.m_20186_() + 0.5, chomplant.m_20189_());
            float newScale = (float)base.m_20318_(1.0f).m_82554_(targetPosition);
            this.setYScale(newScale * Mth.m_14036_((float)(newScale - this.initialDistance), (float)1.0f, (float)1.5f));
        }

        private void updateRotation(Chomplant chomplant, ChomplantBase base) {
            Vec3 angle = base.m_20318_(1.0f).m_82505_(chomplant.m_20318_(1.0f)).m_82541_();
            Pair<Float, Float> rotation = EntityUtils.getRotation(angle);
            this.setProjectileYRot(((Float)rotation.getLeft()).floatValue());
            this.setProjectileXRot(((Float)rotation.getRight()).floatValue());
        }
    }

    public static class ChomplantBase
    extends GahProjectileBase<GahEntityState, GahAnimationState> {
        private static final int NO_OWNER_TICKS_DESPAWN = TimeUtils.secondsToTicks(5.0f);
        private int noOwnerTicks = 0;

        public ChomplantBase(EntityType<? extends ChomplantBase> entityType, Level level) {
            super(entityType, level);
        }

        @Override
        public void m_8119_() {
            super.m_8119_();
            if (this.m_9236_().f_46443_) {
                return;
            }
            this.noOwnerTicks = this.m_19749_() == null ? ++this.noOwnerTicks : 0;
            if (!this.m_9236_().f_46443_ && this.noOwnerTicks >= NO_OWNER_TICKS_DESPAWN) {
                this.m_146870_();
            }
        }

        @Override
        protected void m_7380_(@NotNull CompoundTag nbt) {
            super.m_7380_(nbt);
            nbt.m_128405_("noOwnerTicks", this.noOwnerTicks);
        }

        @Override
        protected void m_7378_(@NotNull CompoundTag nbt) {
            super.m_7378_(nbt);
            this.noOwnerTicks = nbt.m_128451_("noOwnerTicks");
        }

        @Override
        @Nullable
        protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
            return null;
        }

        @Override
        protected GahAnimationState valueToAnimationState(int value) {
            return GahAnimationState.EMPTY;
        }

        @Override
        protected GahEntityState valueToEntityState(int value) {
            return GahEntityState.EMPTY;
        }

        protected void m_6532_(@NotNull HitResult result) {
        }

        @Override
        protected float getGravity() {
            return 0.0f;
        }
    }

    public static enum ChomplantAnimationState implements GahAnimationState
    {
        IDLE(RawAnimation.begin().thenLoop("animation.chomplant.idle"));

        private final RawAnimation animation;

        private ChomplantAnimationState(RawAnimation animation) {
            this.animation = animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }

    private class ChomplantFindPlayerTargetGoal
    extends FindPlayerTargetGoal {
        public ChomplantFindPlayerTargetGoal() {
            super((Mob)Chomplant.this);
        }

        @Override
        public boolean m_8036_() {
            return Chomplant.this.base != null && super.m_8036_();
        }

        @Override
        protected AABB getBoundingBox() {
            return Chomplant.this.base.m_20191_();
        }
    }

    private class ChomplantLocateBaseGoal
    extends Goal {
        private ChomplantLocateBaseGoal() {
        }

        public boolean m_8036_() {
            return Chomplant.this.stem == null || Chomplant.this.base == null;
        }

        public void m_8056_() {
            super.m_8056_();
            ServerLevel level = (ServerLevel)Chomplant.this.m_9236_();
            boolean createdNewBase = Chomplant.this.baseUUID == null;
            Chomplant.this.base = Chomplant.this.baseUUID == null ? this.createNewBase((Level)level) : (ChomplantBase)level.m_8791_(Chomplant.this.baseUUID);
            Chomplant.this.stem = Chomplant.this.stemUUID == null ? this.createNewStem((Level)level) : (ChomplantStem)level.m_8791_(Chomplant.this.stemUUID);
            if (createdNewBase) {
                Chomplant.this.m_6034_(Chomplant.this.m_20185_(), Chomplant.this.m_20186_() + 1.0, Chomplant.this.m_20189_());
            }
        }

        public void m_8041_() {
            super.m_8041_();
            Chomplant.this.base.m_5602_((Entity)Chomplant.this);
            Chomplant.this.stem.m_5602_((Entity)Chomplant.this);
            Chomplant.this.setEntityState(ChomplantState.IDLE);
        }

        private ChomplantBase createNewBase(Level level) {
            ChomplantBase newBase = new ChomplantBase((EntityType<? extends ChomplantBase>)((EntityType)ProjectileEntityRegistry.CHOMPLANT_BASE.get()), level);
            newBase.m_146884_(Chomplant.this.m_20318_(1.0f));
            level.m_7967_((Entity)newBase);
            return newBase;
        }

        private ChomplantStem createNewStem(Level level) {
            ChomplantStem newStem = new ChomplantStem((EntityType<? extends ChomplantStem>)((EntityType)ProjectileEntityRegistry.CHOMPLANT_STEM.get()), level);
            newStem.m_146884_(Chomplant.this.m_20318_(1.0f));
            level.m_7967_((Entity)newStem);
            return newStem;
        }
    }

    private class ChomplantChaseTargetGoal
    extends Goal {
        private static final int HURT_COOLDOWN_TICKS = TimeUtils.secondsToTicks(1.0f);
        private int hurtCooldownTicks;
        private boolean canAttack;

        private ChomplantChaseTargetGoal() {
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chomplant.this.getEntityState() == ChomplantState.IDLE, Chomplant.this.m_5448_() != null});
            if (Chomplant.this.allChecksPass(checks)) {
                Chomplant.this.setEntityState(ChomplantState.CHASE);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return Chomplant.this.m_5448_() != null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.hurtCooldownTicks = 0;
            this.canAttack = true;
        }

        public void m_8037_() {
            this.move();
            this.tryAttack();
        }

        public void m_8041_() {
            super.m_8041_();
            Chomplant.this.setEntityState(ChomplantState.IDLE);
        }

        private void move() {
            LivingEntity target = Chomplant.this.getTargetUnsafe();
            double speed = Chomplant.this.m_21133_(Attributes.f_22279_);
            double followDistance = Chomplant.this.m_21133_(Attributes.f_22277_);
            Vec3 angle = Chomplant.this.m_20318_(1.0f).m_82505_(target.m_146892_()).m_82541_();
            if (Chomplant.this.m_20318_(1.0f).m_82554_(Chomplant.this.base.m_20318_(1.0f)) > followDistance) {
                angle = angle.m_82542_(-1.0, -1.0, -1.0);
            }
            Vec3 currentDelta = Chomplant.this.m_20184_();
            Chomplant.this.m_20334_(this.getNewDirectionSpeed(currentDelta.f_82479_, angle.f_82479_, speed), this.getNewDirectionSpeed(currentDelta.f_82480_, angle.f_82480_, speed) * (double)Chomplant.this.m_217043_().m_216339_(1, 2), this.getNewDirectionSpeed(currentDelta.f_82481_, angle.f_82481_, speed));
            Pair<Float, Float> rotation = EntityUtils.getRotation(angle);
            Chomplant.this.m_146922_(((Float)rotation.getLeft()).floatValue());
            Chomplant.this.m_146926_(((Float)rotation.getRight()).floatValue());
        }

        private double getNewDirectionSpeed(double prevDelta, double angle, double maxSpeed) {
            double newDirectionSpeed = prevDelta + angle / 50.0;
            if (newDirectionSpeed < 0.0) {
                return Math.max(-maxSpeed, newDirectionSpeed);
            }
            return Math.min(maxSpeed, newDirectionSpeed);
        }

        private void tryAttack() {
            if (!this.canAttack) {
                this.canAttack = this.hurtCooldownTicks >= HURT_COOLDOWN_TICKS;
                ++this.hurtCooldownTicks;
            }
            LivingEntity target = Chomplant.this.getTargetUnsafe();
            if (Chomplant.this.m_20191_().m_82400_(0.5).m_82381_(target.m_20191_())) {
                this.canAttack = false;
                this.hurtCooldownTicks = 0;
                Chomplant.this.m_7327_((Entity)target);
            }
        }
    }

    private class ChomplantRetractGoal
    extends Goal {
        private ChomplantRetractGoal() {
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chomplant.this.getEntityState() == ChomplantState.IDLE, Chomplant.this.base != null, Chomplant.this.stem != null});
            return Chomplant.this.allChecksPass(checks);
        }

        public boolean m_8045_() {
            if (Chomplant.this.m_5448_() != null) {
                return false;
            }
            return Chomplant.this.m_20318_(1.0f).m_82554_(this.getTargetLocation()) > 1.0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            Vec3 targetLocation = this.getTargetLocation();
            Vec3 angle = Chomplant.this.m_20318_(1.0f).m_82505_(targetLocation).m_82541_();
            double speed = Chomplant.this.m_21133_(Attributes.f_22279_);
            int randomYSpeed = Chomplant.this.m_217043_().m_216339_(1, 5);
            boolean randomlyMoveOppositeY = Chomplant.this.rollRandomBoolean();
            float randomYMovement = randomYSpeed * (randomlyMoveOppositeY ? -1 : 1);
            Chomplant.this.m_20334_(angle.f_82479_ * speed, angle.f_82480_ * speed * (double)randomYMovement, angle.f_82481_ * speed);
            Pair<Float, Float> rotation = EntityUtils.getRotation(angle);
            Chomplant.this.m_146922_(-((Float)rotation.getLeft()).floatValue());
            Chomplant.this.m_146926_(-((Float)rotation.getRight()).floatValue());
        }

        public void m_8041_() {
            super.m_8041_();
            if (Chomplant.this.m_5448_() != null) {
                return;
            }
            Chomplant.this.m_146884_(this.getTargetLocation());
            Chomplant.this.m_20256_(Vec3.f_82478_);
            Chomplant.this.m_146922_(0.0f);
            Chomplant.this.m_146926_(0.0f);
        }

        private Vec3 getTargetLocation() {
            return new Vec3(Chomplant.this.base.m_20185_(), Chomplant.this.base.m_20186_() + 1.0, Chomplant.this.base.m_20189_());
        }
    }
}

