/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.living.IGahAnimatedMob;
import com.dee12452.gahoodrpg.common.entities.living.ai.GahRangedAttackGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.GahThrowableProjectileBase;
import com.dee12452.gahoodrpg.common.entities.projectile.ItemProjectile;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrazedArcheologist
extends Monster
implements IGahAnimatedMob {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.archeologist.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.archeologist.walk");
    private static final RawAnimation AIM_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.archeologist.aim");
    private static final RawAnimation SHOOT_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.archeologist.shoot");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private State state = State.IDLE;
    private boolean resetAnimation = false;

    public CrazedArcheologist(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.CRAZED_ARCHEOLOGIST_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return SoundEvents.f_12608_;
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
        this.state = State.values()[state];
        if (isClient && this.state == State.SHOOT) {
            this.resetAnimation = true;
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_5545_(@NotNull LevelAccessor levelAccessor, @NotNull MobSpawnType spawnType) {
        return true;
    }

    @Override
    public boolean shouldResetAnimation() {
        return this.resetAnimation;
    }

    @Override
    public void onResetAnimation() {
        this.resetAnimation = false;
    }

    @Override
    public RawAnimation tickAnimation(AnimationState<GeoAnimatable> event) {
        switch (this.state) {
            case WALK: {
                return WALK_ANIMATION;
            }
            case AIM: {
                return AIM_ANIMATION;
            }
            case SHOOT: {
                return SHOOT_ANIMATION;
            }
        }
        return IDLE_ANIMATION;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CrazedArcheologistRangedAttackGoal());
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new CrazedArcheologistRandomMovementGoal());
    }

    private void setState(State state) {
        this.setAnimationState(state.ordinal());
    }

    private static enum State {
        IDLE,
        WALK,
        AIM,
        SHOOT;

    }

    private class CrazedArcheologistRangedAttackGoal
    extends GahRangedAttackGoal {
        public CrazedArcheologistRangedAttackGoal() {
            super((Mob)CrazedArcheologist.this);
        }

        @Override
        public boolean m_8036_() {
            if (super.m_8036_()) {
                CrazedArcheologist.this.setState(State.AIM);
                return true;
            }
            return false;
        }

        public void m_8041_() {
            super.m_8041_();
            CrazedArcheologist.this.setState(State.IDLE);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
        }

        @Override
        @NotNull
        protected GahThrowableProjectileBase createProjectile() {
            return new ItemProjectile((EntityType<? extends ItemProjectile>)((EntityType)ProjectileEntityRegistry.ARCHEOLOGIST_PROJECTILE.get()), (LivingEntity)CrazedArcheologist.this, 0.004f, SoundEvents.f_11933_, SoundEvents.f_11685_);
        }

        @Override
        protected boolean canShoot() {
            if (super.canShoot()) {
                CrazedArcheologist.this.setState(State.SHOOT);
                CrazedArcheologist.this.m_216990_((SoundEvent)Sounds.SHOTGUN_SHOOT.get());
                return true;
            }
            return false;
        }
    }

    private class CrazedArcheologistRandomMovementGoal
    extends WaterAvoidingRandomStrollGoal {
        public CrazedArcheologistRandomMovementGoal() {
            super((PathfinderMob)CrazedArcheologist.this, 1.0, 0.05f);
        }

        public boolean m_8036_() {
            if (super.m_8036_() && CrazedArcheologist.this.state == State.IDLE) {
                CrazedArcheologist.this.setState(State.WALK);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && CrazedArcheologist.this.state == State.WALK;
        }

        public void m_8041_() {
            super.m_8041_();
            if (CrazedArcheologist.this.state == State.WALK) {
                CrazedArcheologist.this.setState(State.IDLE);
            }
        }
    }
}

